/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.extraction;

import java.util.ArrayList;
import java.util.List;
import org.talend.dataquality.semantic.api.CategoryRegistryManager;
import org.talend.dataquality.semantic.extraction.ExtractFromCompound;
import org.talend.dataquality.semantic.extraction.ExtractFromDictionary;
import org.talend.dataquality.semantic.extraction.ExtractFromRegex;
import org.talend.dataquality.semantic.extraction.ExtractFromSemanticType;
import org.talend.dataquality.semantic.extraction.FieldExtractionFunction;
import org.talend.dataquality.semantic.model.DQCategory;
import org.talend.dataquality.semantic.snapshot.DictionarySnapshot;
import org.talend.dataquality.semantic.snapshot.StandardDictionarySnapshotProvider;

public class SemanticExtractionFunctionFactory {
    private SemanticExtractionFunctionFactory() {
    }

    public static FieldExtractionFunction createFieldExtractionFunction(List<String> categoryList) {
        return SemanticExtractionFunctionFactory.createFieldExtractionFunction(categoryList, null);
    }

    public static FieldExtractionFunction createFieldExtractionFunction(List<String> categoryList, DictionarySnapshot dictionarySnapshot) {
        DictionarySnapshot tempDictionarySnapshot = dictionarySnapshot != null ? dictionarySnapshot : new StandardDictionarySnapshotProvider().get();
        ArrayList<ExtractFromSemanticType> extractFunctions = new ArrayList<ExtractFromSemanticType>();
        for (String semanticCategory : categoryList) {
            DQCategory category;
            DQCategory dQCategory = category = tempDictionarySnapshot != null ? tempDictionarySnapshot.getDQCategoryByName(semanticCategory) : CategoryRegistryManager.getInstance().getCategoryMetadataByName(semanticCategory);
            if (category == null) {
                throw new IllegalArgumentException("Invalid Semantic Category Name : " + semanticCategory);
            }
            ExtractFromSemanticType function = SemanticExtractionFunctionFactory.getFunction(category, tempDictionarySnapshot);
            if (function == null) continue;
            extractFunctions.add(function);
        }
        return new FieldExtractionFunction(extractFunctions);
    }

    protected static ExtractFromSemanticType getFunction(DQCategory category, DictionarySnapshot dicoSnapshot) {
        ExtractFromSemanticType function = null;
        switch (category.getType()) {
            case DICT: {
                function = new ExtractFromDictionary(dicoSnapshot, category);
                break;
            }
            case REGEX: {
                function = new ExtractFromRegex(dicoSnapshot, category);
                break;
            }
            case COMPOUND: {
                function = new ExtractFromCompound(dicoSnapshot, category);
                break;
            }
        }
        return function;
    }
}

