/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.index;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataquality.semantic.index.DictionarySearchMode;

public abstract class AbstractDictionarySearcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDictionarySearcher.class);
    public static final String F_DOCID = "docid";
    public static final String F_WORD = "word";
    public static final String F_SYNTERM = "synterm";
    public static final String F_RAW = "raw";
    public static final String F_CATID = "catid";
    protected int topDocLimit = 3;
    private int maxEdits = 2;
    private static final int MAX_TOKEN_COUNT_FOR_KEYWORD_MATCH = 20;
    private static final int MAX_CHAR_COUNT_FOR_DICTIONARY_MATCH = 100;
    protected DictionarySearchMode searchMode = DictionarySearchMode.MATCH_SEMANTIC_DICTIONARY;

    public abstract TopDocs searchDocumentBySynonym(String var1) throws IOException;

    public abstract Document getDocument(int var1);

    public void setTopDocLimit(int topDocLimit) {
        this.topDocLimit = topDocLimit;
    }

    public void setMaxEdits(int maxEdits) {
        this.maxEdits = maxEdits;
    }

    public DictionarySearchMode getSearchMode() {
        return this.searchMode;
    }

    public void setSearchMode(DictionarySearchMode searchMode) {
        this.searchMode = searchMode;
    }

    protected Query getTermQuery(String field, String text, boolean fuzzy) {
        Term term = new Term(field, text);
        return fuzzy ? new FuzzyQuery(term, this.maxEdits) : new TermQuery(term);
    }

    protected Query createQueryForSemanticDictionaryMatch(String input) throws IOException {
        if (input.length() > 100) {
            return new TermQuery(new Term(F_SYNTERM, ""));
        }
        return this.getTermQuery(F_SYNTERM, StringUtils.join(AbstractDictionarySearcher.getTokensFromAnalyzer(input), (char)' '), false);
    }

    protected Query createQueryForSemanticKeywordMatch(String input) throws IOException {
        BooleanQuery booleanQuery = new BooleanQuery();
        List<String> tokens = AbstractDictionarySearcher.getTokensFromAnalyzer(input);
        for (int i = 0; i < Math.min(tokens.size(), 20); ++i) {
            booleanQuery.add(this.getTermQuery(F_SYNTERM, tokens.get(i), false), BooleanClause.Occur.SHOULD);
        }
        return booleanQuery;
    }

    public static String getJointTokens(String input) {
        return StringUtils.join(AbstractDictionarySearcher.getTokensFromAnalyzer(input), (char)' ');
    }

    public static List<String> getTokensFromAnalyzer(String input) {
        StandardTokenizer tokenStream = new StandardTokenizer((Reader)new StringReader(input));
        StandardFilter result = new StandardFilter((TokenStream)tokenStream);
        result = new LowerCaseFilter((TokenStream)result);
        result = new ASCIIFoldingFilter((TokenStream)result);
        CharTermAttribute charTermAttribute = (CharTermAttribute)result.addAttribute(CharTermAttribute.class);
        ArrayList<String> termList = new ArrayList<String>();
        try {
            tokenStream.reset();
            while (result.incrementToken()) {
                String term = charTermAttribute.toString();
                termList.add(term);
            }
            result.close();
        }
        catch (IOException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        return termList;
    }
}

