/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.index;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.TermsFilter;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CachingWrapperFilter;
import org.apache.lucene.search.FieldCacheTermsFilter;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataquality.semantic.index.AbstractDictionarySearcher;
import org.talend.dataquality.semantic.index.ClassPathDirectory;
import org.talend.dataquality.semantic.model.DQCategory;
import org.talend.dataquality.semantic.model.ValidationMode;

public class DictionarySearcher
extends AbstractDictionarySearcher {
    public static final String UNABLE_TO_OPEN_INDEX = "Unable to open synonym index.";
    private static final Logger LOGGER = LoggerFactory.getLogger(DictionarySearcher.class);
    private SearcherManager mgr;
    private Map<String, CachingWrapperFilter> categoryToCache = new HashMap<String, CachingWrapperFilter>();
    private CachingWrapperFilter cachingWrapperFilterForDiscovery;

    public DictionarySearcher(String indexPath) {
        try {
            FSDirectory indexDir = FSDirectory.open((File)new File(indexPath));
            this.mgr = new SearcherManager((Directory)indexDir, null);
        }
        catch (IOException e) {
            LOGGER.error(UNABLE_TO_OPEN_INDEX, (Throwable)e);
        }
    }

    public DictionarySearcher(URI indexPathURI) {
        try {
            Directory indexDir = ClassPathDirectory.open(indexPathURI);
            this.mgr = new SearcherManager(indexDir, null);
        }
        catch (IOException e) {
            LOGGER.error(UNABLE_TO_OPEN_INDEX, (Throwable)e);
        }
    }

    public DictionarySearcher(Directory indexDir) {
        try {
            this.mgr = new SearcherManager(indexDir, null);
        }
        catch (IOException e) {
            LOGGER.error(UNABLE_TO_OPEN_INDEX, (Throwable)e);
        }
    }

    public void setCategoriesToSearch(List<String> categoryIds) {
        this.cachingWrapperFilterForDiscovery = new CachingWrapperFilter((Filter)new FieldCacheTermsFilter("catid", categoryIds.toArray(new String[categoryIds.size()])));
    }

    @Override
    public TopDocs searchDocumentBySynonym(String stringToSearch) throws IOException {
        Query query;
        switch (this.searchMode) {
            case MATCH_SEMANTIC_KEYWORD: {
                query = this.createQueryForSemanticKeywordMatch(stringToSearch);
                break;
            }
            default: {
                query = this.createQueryForSemanticDictionaryMatch(stringToSearch);
            }
        }
        IndexSearcher searcher = (IndexSearcher)this.mgr.acquire();
        TopDocs topDocs = searcher.search(query, (Filter)this.cachingWrapperFilterForDiscovery, this.topDocLimit);
        this.mgr.release((Object)searcher);
        return topDocs;
    }

    @Override
    public Document getDocument(int docNum) {
        Document doc = null;
        try {
            IndexSearcher searcher = (IndexSearcher)this.mgr.acquire();
            doc = searcher.doc(docNum);
            this.mgr.release((Object)searcher);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
        }
        return doc;
    }

    public boolean validDocumentWithCategories(String stringToSearch, DQCategory semanticType, Set<DQCategory> children) throws IOException {
        boolean hasChildren;
        Query query;
        switch (this.searchMode) {
            case MATCH_SEMANTIC_KEYWORD: {
                query = this.createQueryForSemanticKeywordMatch(stringToSearch);
                break;
            }
            default: {
                query = this.createQueryForSemanticDictionaryMatch(stringToSearch);
            }
        }
        IndexSearcher searcher = (IndexSearcher)this.mgr.acquire();
        CachingWrapperFilter cachingWrapperFilter = this.categoryToCache.get(semanticType.getId());
        boolean bl = hasChildren = !CollectionUtils.isEmpty(children);
        if (cachingWrapperFilter == null) {
            if (hasChildren) {
                HashSet<String> childrenId = new HashSet<String>();
                for (DQCategory category : children) {
                    childrenId.add(category.getId());
                }
                cachingWrapperFilter = new CachingWrapperFilter((Filter)new FieldCacheTermsFilter("catid", childrenId.toArray(new String[childrenId.size()])));
            } else {
                cachingWrapperFilter = new CachingWrapperFilter((Filter)new FieldCacheTermsFilter("catid", new String[]{semanticType.getId()}));
            }
            this.categoryToCache.put(semanticType.getId(), cachingWrapperFilter);
        }
        TopDocs docs = searcher.search(query, (Filter)cachingWrapperFilter, this.topDocLimit);
        ValidationMode validationMode = ValidationMode.EXACT;
        if (!hasChildren && semanticType.getValidationMode() != null && ValidationMode.SIMPLIFIED.equals((Object)(validationMode = semanticType.getValidationMode()))) {
            this.mgr.release((Object)searcher);
            return docs.totalHits != 0;
        }
        boolean validDocument = false;
        for (int i = 0; i < docs.scoreDocs.length && !validDocument; ++i) {
            Document document = searcher.doc(docs.scoreDocs[i].doc);
            if (hasChildren) {
                validationMode = this.getChildrenValidationMode(children, document);
            }
            validDocument = this.validDocumentByValidationMode(document, stringToSearch, validationMode);
        }
        this.mgr.release((Object)searcher);
        return validDocument;
    }

    private ValidationMode getChildrenValidationMode(Set<DQCategory> children, Document document) {
        for (DQCategory child : children) {
            if (!child.getId().equals(document.getField("catid").stringValue())) continue;
            return child.getValidationMode() != null ? child.getValidationMode() : ValidationMode.EXACT;
        }
        LOGGER.error("The document does not belong to any children category");
        return ValidationMode.EXACT;
    }

    private boolean validDocumentByValidationMode(Document document, String stringToSearch, ValidationMode validationMode) throws IOException {
        if (ValidationMode.SIMPLIFIED.equals((Object)validationMode)) {
            return true;
        }
        String transformedString = this.transformSringByValidationMode(stringToSearch, validationMode);
        if (!StringUtils.isEmpty((CharSequence)transformedString)) {
            for (String raw : document.getValues("raw")) {
                if (!transformedString.equals(this.transformSringByValidationMode(raw, validationMode))) continue;
                return true;
            }
        }
        return false;
    }

    private String transformSringByValidationMode(String stringToTransform, ValidationMode validationMode) {
        if (ValidationMode.EXACT_IGNORE_CASE_AND_ACCENT.equals((Object)validationMode)) {
            return StringUtils.stripAccents((String)stringToTransform.toLowerCase());
        }
        return stringToTransform;
    }

    protected Filter createFilterForSemanticTypes(Set<String> semanticTypes) {
        ArrayList<Term> terms = new ArrayList<Term>();
        for (String semanticType : semanticTypes) {
            terms.add(new Term("word", semanticType));
        }
        return new TermsFilter(terms);
    }

    public String getWordByDocNumber(int docNo) {
        Document document = this.getDocument(docNo);
        return document != null ? document.getValues("word")[0] : null;
    }

    public String[] getSynonymsByDocNumber(int docNo) {
        Document document = this.getDocument(docNo);
        return document != null ? document.getValues("raw") : null;
    }

    public int getNumDocs() {
        try {
            IndexSearcher searcher = (IndexSearcher)this.mgr.acquire();
            int numDocs = searcher.getIndexReader().numDocs();
            this.mgr.release((Object)searcher);
            return numDocs;
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    public void close() {
        try {
            ((IndexSearcher)this.mgr.acquire()).getIndexReader().close();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void maybeRefreshIndex() {
        try {
            this.mgr.maybeRefresh();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public TopDocs findSimilarValuesInCategory(String input, String category) throws IOException {
        BooleanQuery combinedQuery = new BooleanQuery();
        if (category != null && !"".equals(category)) {
            Term catTerm = new Term("word", category);
            TermQuery catQuery = new TermQuery(catTerm);
            combinedQuery.add((Query)catQuery, BooleanClause.Occur.MUST);
        }
        BooleanQuery valueQuery = new BooleanQuery();
        List<String> tokens = DictionarySearcher.getTokensFromAnalyzer(input);
        Query inputTermQuery = this.getTermQuery("synterm", StringUtils.join(tokens, (char)' '), true);
        valueQuery.add(inputTermQuery, BooleanClause.Occur.SHOULD);
        BooleanQuery inputTokenQuery = new BooleanQuery();
        for (String token : tokens) {
            inputTokenQuery.add(this.getTermQuery("synterm", token, true), BooleanClause.Occur.SHOULD);
        }
        valueQuery.add((Query)inputTokenQuery, BooleanClause.Occur.SHOULD);
        combinedQuery.add((Query)valueQuery, BooleanClause.Occur.MUST);
        IndexSearcher searcher = (IndexSearcher)this.mgr.acquire();
        TopDocs topDocs = searcher.search((Query)combinedQuery, 50);
        this.mgr.release((Object)searcher);
        return topDocs;
    }

    public List<Document> listDocumentsByCategoryId(String catId) {
        return this.listDocumentsByCategoryId(catId, 0, Integer.MAX_VALUE);
    }

    public List<Document> listDocumentsByCategoryId(String catId, int offset, int n) {
        try {
            TopDocs topDocs;
            IndexSearcher searcher = (IndexSearcher)this.mgr.acquire();
            IndexReader reader = searcher.getIndexReader();
            Term catTerm = new Term("catid", catId);
            TermQuery catQuery = new TermQuery(catTerm);
            if (offset <= 0) {
                topDocs = searcher.search((Query)catQuery, n);
            } else {
                TopDocs docs = searcher.search((Query)catQuery, offset + n);
                TermQuery q = new TermQuery(new Term("catid", catId));
                topDocs = searcher.searchAfter(docs.scoreDocs[Math.min(docs.totalHits, offset) - 1], (Query)q, n);
            }
            ArrayList<Document> listDocs = new ArrayList<Document>(topDocs.totalHits);
            for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                Document luceneDoc = reader.document(scoreDoc.doc);
                listDocs.add(luceneDoc);
            }
            this.mgr.release((Object)searcher);
            return listDocs;
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<String> searchPhraseInSemanticCategory(String catId, String phrase) {
        Query catQuery = this.getTermQuery("catid", catId, false);
        String filteredString = StringUtils.join(DictionarySearcher.getTokensFromAnalyzer(phrase), (char)' ');
        PrefixQuery syntermQuery = new PrefixQuery(new Term("synterm", filteredString));
        BooleanQuery combinedQuery = new BooleanQuery();
        combinedQuery.add(catQuery, BooleanClause.Occur.MUST);
        combinedQuery.add((Query)syntermQuery, BooleanClause.Occur.MUST);
        try {
            IndexSearcher searcher = (IndexSearcher)this.mgr.acquire();
            IndexReader reader = searcher.getIndexReader();
            TopDocs topDocs = searcher.search((Query)combinedQuery, 1000);
            ArrayList<String> listDocs = new ArrayList<String>();
            for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                Document luceneDoc = reader.document(scoreDoc.doc);
                listDocs.addAll(Arrays.asList(luceneDoc.getValues("raw")));
            }
            this.mgr.release((Object)searcher);
            return listDocs;
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }
}

