/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.index;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JARDirectory
extends Directory {
    private static final Logger LOGGER = LoggerFactory.getLogger(JARDirectory.class);
    private static final Object indexExtractionLock = new Object();
    private final JARDescriptor jarDescriptor;
    final String extractPath;
    final String indexDirectory;
    private FSDirectory fsDir;

    public JARDirectory(String extractPath, JARDescriptor descriptor, String directory) {
        this.extractPath = extractPath;
        this.jarDescriptor = descriptor;
        this.indexDirectory = directory;
        try {
            this.extractIndex();
        }
        catch (IOException e) {
            LOGGER.error("Failed to extract index: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractIndex() throws IOException {
        String unzipFolderName = this.extractPath + File.separator + this.indexDirectory + File.separator;
        final File destinationFolder = Paths.get(unzipFolderName, new String[0]).toFile();
        LOGGER.info("Extracting index to temporary directory: " + destinationFolder.getAbsolutePath());
        if (destinationFolder.exists()) {
            this.fsDir = FSDirectory.open((File)destinationFolder);
        } else {
            Object object = indexExtractionLock;
            synchronized (object) {
                Path start = this.jarDescriptor.fileSystem.getPath(this.indexDirectory, new String[0]);
                if (!destinationFolder.exists()) {
                    destinationFolder.mkdirs();
                }
                Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
                        Path destFilePath = Paths.get(destinationFolder.toString(), file.getFileName().toString());
                        Files.copy(file, destFilePath, StandardCopyOption.REPLACE_EXISTING);
                        return FileVisitResult.CONTINUE;
                    }
                });
                this.fsDir = FSDirectory.open((File)destinationFolder);
            }
        }
    }

    public void close() throws IOException {
        this.fsDir.close();
    }

    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        return this.fsDir.createOutput(name, context);
    }

    public void deleteFile(String name) throws IOException {
        this.fsDir.deleteFile(name);
    }

    public boolean fileExists(String name) throws IOException {
        return this.fsDir.fileExists(name);
    }

    public long fileLength(String name) throws IOException {
        return this.fsDir.fileLength(name);
    }

    public String[] listAll() throws IOException {
        return this.fsDir.listAll();
    }

    public IndexInput openInput(String arg0, IOContext arg1) throws IOException {
        return this.fsDir.openInput(arg0, arg1);
    }

    public void sync(Collection<String> arg0) throws IOException {
        this.fsDir.sync(arg0);
    }

    public void clearLock(String arg0) throws IOException {
        this.fsDir.clearLock(arg0);
    }

    public LockFactory getLockFactory() {
        return this.fsDir.getLockFactory();
    }

    public Lock makeLock(String arg0) {
        return this.fsDir.makeLock(arg0);
    }

    public void setLockFactory(LockFactory arg0) throws IOException {
        this.fsDir.setLockFactory(arg0);
    }

    public static class JARDescriptor {
        FileSystem fileSystem;
        String jarFileName;
    }
}

