/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.snapshot;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.SerializationUtils;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedClassifier;
import org.talend.dataquality.semantic.index.Index;
import org.talend.dataquality.semantic.model.DQCategory;

public class DictionarySnapshot
implements Serializable {
    private static final long serialVersionUID = -6215879188951573104L;
    private Map<String, DQCategory> metadata = new HashMap<String, DQCategory>();
    private Index sharedDataDict;
    private Index customDataDict;
    private Index keyword;
    private UserDefinedClassifier regexClassifier;

    public DictionarySnapshot(Map<String, DQCategory> metadata, Index sharedDataDict, Index customDataDict, Index keyword, UserDefinedClassifier regexClassifier) {
        metadata.entrySet().forEach(entry -> this.metadata.put((String)entry.getKey(), (DQCategory)SerializationUtils.clone((Serializable)((Serializable)entry.getValue()))));
        this.sharedDataDict = sharedDataDict;
        this.customDataDict = customDataDict;
        this.keyword = keyword;
        this.regexClassifier = (UserDefinedClassifier)SerializationUtils.clone((Serializable)regexClassifier);
    }

    public Map<String, DQCategory> getMetadata() {
        return this.metadata;
    }

    public DQCategory getDQCategoryByName(String categoryName) {
        DQCategory dqCategory = null;
        for (DQCategory dqCat : this.getMetadata().values()) {
            if (!dqCat.getName().equals(categoryName)) continue;
            dqCategory = dqCat;
            break;
        }
        return dqCategory;
    }

    public DQCategory getDQCategoryById(String categoryId) {
        DQCategory dqCategory = null;
        for (DQCategory dqCat : this.getMetadata().values()) {
            if (!dqCat.getId().equals(categoryId)) continue;
            dqCategory = dqCat;
            break;
        }
        return dqCategory;
    }

    public Index getSharedDataDict() {
        return this.sharedDataDict;
    }

    public Index getCustomDataDict() {
        return this.customDataDict;
    }

    public Index getKeyword() {
        return this.keyword;
    }

    public UserDefinedClassifier getRegexClassifier() {
        return this.regexClassifier;
    }
}

