/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.statistics;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.talend.dataquality.common.inference.Analyzer;
import org.talend.dataquality.common.inference.Metadata;
import org.talend.dataquality.common.inference.ResizableList;
import org.talend.dataquality.semantic.exception.DQSemanticRuntimeException;
import org.talend.dataquality.semantic.index.Index;
import org.talend.dataquality.semantic.recognizer.CategoryFrequency;
import org.talend.dataquality.semantic.recognizer.CategoryRecognizer;
import org.talend.dataquality.semantic.recognizer.DefaultCategoryRecognizer;
import org.talend.dataquality.semantic.snapshot.DictionarySnapshot;
import org.talend.dataquality.semantic.statistics.SemanticType;

public class SemanticAnalyzer
implements Analyzer<SemanticType> {
    private static final long serialVersionUID = 6808620909722453108L;
    private static float DEFAULT_WEIGHT_VALUE = 0.1f;
    private final ResizableList<SemanticType> results = new ResizableList(SemanticType.class);
    private final Map<Integer, CategoryRecognizer> columnIdxToCategoryRecognizer = new HashMap<Integer, CategoryRecognizer>();
    private int limit = 10000;
    private int currentCount = 0;
    private Map<Metadata, List<String>> metadataMap;
    private float weight = DEFAULT_WEIGHT_VALUE;
    private DictionarySnapshot dictionarySnapshot;

    public SemanticAnalyzer(DictionarySnapshot dictionarySnapshot) {
        if (dictionarySnapshot == null) {
            throw new NullPointerException("Dictionary dictionarySnapshot is Null.");
        }
        this.dictionarySnapshot = dictionarySnapshot;
        this.metadataMap = new HashMap<Metadata, List<String>>();
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    public void init() {
        Index customDict;
        this.currentCount = 0;
        this.columnIdxToCategoryRecognizer.clear();
        this.results.clear();
        if (this.dictionarySnapshot != null && (customDict = this.dictionarySnapshot.getCustomDataDict()) != null) {
            customDict.initIndex();
        }
    }

    public boolean analyze(String ... record) {
        this.results.resize(record.length);
        this.resizeCategoryRecognizer(record);
        if (this.currentCount < this.limit || this.limit <= 0) {
            for (int i = 0; i < record.length; ++i) {
                CategoryRecognizer categoryRecognizer = this.columnIdxToCategoryRecognizer.get(i);
                if (categoryRecognizer == null) {
                    throw new DQSemanticRuntimeException("CategoryRecognizer is null for record and i=" + i + " " + Arrays.asList(record));
                }
                categoryRecognizer.process(record[i]);
            }
            ++this.currentCount;
        }
        return true;
    }

    private void resizeCategoryRecognizer(String[] record) {
        if (this.columnIdxToCategoryRecognizer.size() > 0) {
            return;
        }
        for (int idx = 0; idx < record.length; ++idx) {
            try {
                this.columnIdxToCategoryRecognizer.put(idx, new DefaultCategoryRecognizer(this.dictionarySnapshot));
                continue;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to configure category recognizer with dictionary snapshot.", e);
            }
        }
    }

    public void end() {
    }

    public List<SemanticType> getResult() {
        for (Map.Entry<Integer, CategoryRecognizer> entry : this.columnIdxToCategoryRecognizer.entrySet()) {
            Integer colIdx = entry.getKey();
            String columnName = null;
            if (this.metadataMap.get(Metadata.HEADER_NAME) != null) {
                List<String> metadata = this.metadataMap.get(Metadata.HEADER_NAME);
                columnName = metadata.get(colIdx);
            }
            Collection<CategoryFrequency> result = entry.getValue().getResult(columnName, this.weight);
            for (CategoryFrequency semCategory : result) {
                ((SemanticType)this.results.get(colIdx.intValue())).increment(semCategory, semCategory.getCount());
            }
        }
        return this.results;
    }

    public void close() throws Exception {
        for (CategoryRecognizer catRecognizer : this.columnIdxToCategoryRecognizer.values()) {
            catRecognizer.end();
        }
    }

    public void setMetadata(Metadata metadata, List<String> values) {
        this.metadataMap.put(metadata, values);
    }
}

