/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.statistics;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataquality.common.inference.QualityAnalyzer;
import org.talend.dataquality.common.inference.ResizableList;
import org.talend.dataquality.common.inference.ValueQualityStatistics;
import org.talend.dataquality.common.util.LFUCache;
import org.talend.dataquality.semantic.classifier.ISubCategoryClassifier;
import org.talend.dataquality.semantic.classifier.SemanticCategoryEnum;
import org.talend.dataquality.semantic.classifier.impl.DataDictFieldClassifier;
import org.talend.dataquality.semantic.model.CategoryType;
import org.talend.dataquality.semantic.model.DQCategory;
import org.talend.dataquality.semantic.recognizer.DefaultCategoryRecognizer;
import org.talend.dataquality.semantic.snapshot.DictionarySnapshot;

public class SemanticQualityAnalyzer
extends QualityAnalyzer<ValueQualityStatistics, String[]> {
    private static final long serialVersionUID = -5951511723860660263L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SemanticQualityAnalyzer.class);
    private final ResizableList<ValueQualityStatistics> results = new ResizableList(ValueQualityStatistics.class);
    private final Map<String, LFUCache<String, Boolean>> knownValidationCategoryCache = new HashMap<String, LFUCache<String, Boolean>>();
    private DictionarySnapshot dictionarySnapshot;
    private ISubCategoryClassifier regexClassifier;
    private ISubCategoryClassifier dataDictClassifier;

    public SemanticQualityAnalyzer(DictionarySnapshot dictionarySnapshot, String[] types, boolean isStoreInvalidValues) {
        this.dictionarySnapshot = dictionarySnapshot;
        this.isStoreInvalidValues = isStoreInvalidValues;
        this.init();
        this.setTypes(types);
    }

    public SemanticQualityAnalyzer(DictionarySnapshot dictionarySnapshot, String ... types) {
        this(dictionarySnapshot, types, false);
    }

    public void setTypes(String[] types) {
        ArrayList<String> idList = new ArrayList<String>();
        for (String type : types) {
            DQCategory dqCat = null;
            for (DQCategory tmpCat : this.dictionarySnapshot.getMetadata().values()) {
                if (!type.equals(tmpCat.getName())) continue;
                tmpCat.setChildren(this.getChildrenCategories(tmpCat.getId()));
                dqCat = tmpCat;
                break;
            }
            if (dqCat == null) {
                idList.add(SemanticCategoryEnum.UNKNOWN.name());
                continue;
            }
            idList.add(dqCat.getId());
        }
        super.setTypes((Object)idList.toArray(new String[idList.size()]));
    }

    public void init() {
        try {
            DefaultCategoryRecognizer recognizer = new DefaultCategoryRecognizer(this.dictionarySnapshot);
            this.regexClassifier = recognizer.getUserDefineClassifier();
            this.dataDictClassifier = recognizer.getDataDictFieldClassifier();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        this.results.clear();
    }

    public void setStoreInvalidValues(boolean isStoreInvalidValues) {
        this.isStoreInvalidValues = isStoreInvalidValues;
    }

    public boolean analyze(String ... record) {
        if (record == null) {
            this.results.resize(0);
            return true;
        }
        this.results.resize(record.length);
        for (int i = 0; i < record.length; ++i) {
            String semanticType = ((String[])this.getTypes())[i];
            String value = record[i];
            ValueQualityStatistics valueQuality = (ValueQualityStatistics)this.results.get(i);
            if (value == null || value.trim().length() == 0) {
                valueQuality.incrementEmpty();
                continue;
            }
            this.analyzeValue(semanticType, value, valueQuality);
        }
        return true;
    }

    private void analyzeValue(String catId, String value, ValueQualityStatistics valueQuality) {
        DQCategory category = this.dictionarySnapshot.getMetadata().get(catId);
        if (category == null) {
            valueQuality.incrementValid();
            return;
        }
        if (category.getCompleteness() != null && category.getCompleteness().booleanValue()) {
            if (!Boolean.TRUE.equals(category.getDeleted()) && this.isValid(category, value)) {
                valueQuality.incrementValid();
            } else {
                valueQuality.incrementInvalid();
                this.processInvalidValue(valueQuality, value);
            }
        } else {
            valueQuality.incrementValid();
        }
    }

    public boolean isValid(DQCategory category, String value) {
        LFUCache categoryCache = this.knownValidationCategoryCache.get(category.getId());
        if (categoryCache == null) {
            categoryCache = new LFUCache(10, 1000, 0.01f);
            this.knownValidationCategoryCache.put(category.getId(), (LFUCache<String, Boolean>)categoryCache);
        } else {
            Boolean isValid = (Boolean)categoryCache.get((Object)value);
            if (isValid != null) {
                return isValid;
            }
        }
        boolean validCat = false;
        switch (category.getType()) {
            case REGEX: {
                validCat = this.regexClassifier.validCategories(value, category, null);
                break;
            }
            case DICT: {
                validCat = this.dataDictClassifier.validCategories(value, category, null);
                break;
            }
            case COMPOUND: {
                validCat = this.isCompoundValid(category, value);
                break;
            }
        }
        categoryCache.put((Object)value, (Object)validCat);
        return validCat;
    }

    private boolean isCompoundValid(DQCategory category, String value) {
        boolean validCat = false;
        HashSet<DQCategory> regexChildrenCategories = new HashSet<DQCategory>();
        HashSet<DQCategory> dictChildrenCategories = new HashSet<DQCategory>();
        for (DQCategory cat : category.getChildren()) {
            if (CategoryType.DICT.equals((Object)cat.getType())) {
                dictChildrenCategories.add(cat);
                continue;
            }
            if (!CategoryType.REGEX.equals((Object)cat.getType())) continue;
            regexChildrenCategories.add(cat);
        }
        if (!CollectionUtils.isEmpty(regexChildrenCategories)) {
            validCat = this.regexClassifier.validCategories(value, category, regexChildrenCategories);
        }
        if (!validCat && !CollectionUtils.isEmpty(dictChildrenCategories)) {
            validCat = this.dataDictClassifier.validCategories(value, category, dictChildrenCategories);
        }
        return validCat;
    }

    private void processInvalidValue(ValueQualityStatistics valueQuality, String invalidValue) {
        if (this.isStoreInvalidValues) {
            valueQuality.appendInvalidValue(invalidValue);
        }
    }

    private List<DQCategory> getChildrenCategories(String id) {
        ArrayDeque<String> catToSee = new ArrayDeque<String>();
        HashSet<String> catAlreadySeen = new HashSet<String>();
        ArrayList<DQCategory> children = new ArrayList<DQCategory>();
        catToSee.add(id);
        while (!catToSee.isEmpty()) {
            String currentCategory = (String)catToSee.pop();
            DQCategory dqCategory = this.dictionarySnapshot.getMetadata().get(currentCategory);
            if (dqCategory == null) continue;
            if (!CollectionUtils.isEmpty((Collection)dqCategory.getChildren())) {
                for (DQCategory child : dqCategory.getChildren()) {
                    if (catAlreadySeen.contains(child.getId())) continue;
                    catAlreadySeen.add(child.getId());
                    catToSee.add(child.getId());
                }
                continue;
            }
            if (currentCategory.equals(id)) continue;
            children.add(dqCategory);
        }
        return children;
    }

    public void end() {
    }

    public List<ValueQualityStatistics> getResult() {
        return this.results;
    }

    public void close() throws Exception {
        ((DataDictFieldClassifier)this.dataDictClassifier).closeIndex();
    }
}

