/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic;

import java.io.Serializable;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.math3.exception.NotANumberException;
import org.apache.commons.math3.exception.NotFiniteNumberException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.Pair;

public class Distribution<T extends Serializable>
implements Serializable {
    private final double[] probabilities;
    private Random random;
    private final List<T> singletons;

    public Distribution(List<Pair<T, Double>> pmf) {
        this(pmf, new SecureRandom());
    }

    public Distribution(List<Pair<T, Double>> pmf, Random rnd) {
        this.random = rnd;
        this.singletons = new ArrayList<T>(pmf.size());
        double[] probs = new double[pmf.size()];
        for (int i = 0; i < pmf.size(); ++i) {
            Pair<T, Double> sample = pmf.get(i);
            this.singletons.add(sample.getKey());
            double p = (Double)sample.getValue();
            if (p < 0.0) {
                throw new NotPositiveException((Number)sample.getValue());
            }
            if (Double.isInfinite(p)) {
                throw new NotFiniteNumberException((Number)p, new Object[0]);
            }
            if (Double.isNaN(p)) {
                throw new NotANumberException();
            }
            probs[i] = p;
        }
        this.probabilities = MathArrays.normalizeArray((double[])probs, (double)1.0);
    }

    public T sample() {
        double randomValue = this.random.nextDouble();
        double sum = 0.0;
        for (int i = 0; i < this.probabilities.length; ++i) {
            if (!(randomValue < (sum += this.probabilities[i]))) continue;
            return (T)((Serializable)this.singletons.get(i));
        }
        return (T)((Serializable)this.singletons.get(this.singletons.size() - 1));
    }
}

