/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataquality.semantic.api.DictionaryUtils;
import org.talend.dataquality.semantic.model.DQCategory;

public class CategoryMetadataUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CategoryMetadataUtils.class);

    private CategoryMetadataUtils() {
    }

    public static Map<String, DQCategory> loadMetadataFromIndex(Directory directory) {
        HashMap<String, DQCategory> sharedMetadata = new HashMap<String, DQCategory>();
        HashMap<String, Set<String>> categoryToParents = new HashMap<String, Set<String>>();
        try (DirectoryReader reader = DirectoryReader.open((Directory)directory);){
            Set<Integer> deletedDocs = DictionaryUtils.getDeletedDocs(directory);
            for (int i = 0; i < reader.maxDoc(); ++i) {
                Document doc;
                DQCategory dqCat;
                if (deletedDocs.contains(i) || !CategoryMetadataUtils.isAvailableCategory(dqCat = DictionaryUtils.categoryFromDocument(doc = reader.document(i)))) continue;
                sharedMetadata.put(dqCat.getId(), dqCat);
                if (CollectionUtils.isEmpty((Collection)dqCat.getChildren())) continue;
                CategoryMetadataUtils.fillCategoryToParents(categoryToParents, dqCat);
            }
            categoryToParents.entrySet().forEach(entry -> CategoryMetadataUtils.addParentReference(sharedMetadata, entry));
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return sharedMetadata;
    }

    private static void addParentReference(HashMap<String, DQCategory> sharedMetadata, Map.Entry<String, Set<String>> entry) {
        if (sharedMetadata.get(entry.getKey()) != null) {
            ArrayList<DQCategory> parentCategoryList = new ArrayList<DQCategory>();
            for (String childCategoryId : entry.getValue()) {
                parentCategoryList.add(new DQCategory(childCategoryId));
            }
            sharedMetadata.get(entry.getKey()).setParents(parentCategoryList);
        }
    }

    private static void fillDQcategoryMetadata(HashMap<String, DQCategory> sharedMetadata, Map<String, Set<String>> categoryToParents, Document doc) {
        DQCategory dqCat = DictionaryUtils.categoryFromDocument(doc);
        if (CategoryMetadataUtils.isAvailableCategory(dqCat)) {
            sharedMetadata.put(dqCat.getId(), dqCat);
            if (!CollectionUtils.isEmpty((Collection)dqCat.getChildren())) {
                CategoryMetadataUtils.fillCategoryToParents(categoryToParents, dqCat);
            }
        }
    }

    private static boolean isAvailableCategory(DQCategory dqCat) {
        return !Boolean.TRUE.equals(dqCat.getDeleted());
    }

    private static void fillCategoryToParents(Map<String, Set<String>> categoryToParents, DQCategory dqCat) {
        for (DQCategory cat : dqCat.getChildren()) {
            categoryToParents.computeIfAbsent(cat.getId(), k -> new HashSet());
            categoryToParents.get(cat.getId()).add(dqCat.getId());
        }
    }
}

