/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.daikon.multitenant.context.TenancyContextHolder;
import org.talend.daikon.multitenant.core.Tenant;
import org.talend.dataquality.semantic.api.CustomDictionaryHolder;
import org.talend.dataquality.semantic.api.DictionaryUtils;
import org.talend.dataquality.semantic.api.SemanticProperties;
import org.talend.dataquality.semantic.exception.DQSemanticRuntimeException;
import org.talend.dataquality.semantic.index.ClassPathDirectory;
import org.talend.dataquality.semantic.model.CategoryType;
import org.talend.dataquality.semantic.model.DQCategory;
import org.talend.dataquality.semantic.snapshot.SharedDictionary;

public class CategoryRegistryManager {
    public static final String DEFAULT_TENANT_ID = "t_default";
    private static final Logger LOGGER = LoggerFactory.getLogger(CategoryRegistryManager.class);
    private final Map<String, CustomDictionaryHolder> customDictionaryHolderMap = new ConcurrentHashMap<String, CustomDictionaryHolder>();
    private static final Object indexExtractionLock = new Object();
    private static CategoryRegistryManager instance;
    private final ObjectMapper mapper = new ObjectMapper();
    private final SemanticProperties properties;
    private final SharedDictionary sharedDictionary;

    private CategoryRegistryManager() {
        this(new SemanticProperties());
    }

    public CategoryRegistryManager(SemanticProperties properties) {
        this.properties = properties;
        try {
            this.extractSharedCategories();
            this.sharedDictionary = new SharedDictionary(properties);
        }
        catch (IOException | URISyntaxException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new DQSemanticRuntimeException(e);
        }
    }

    @Deprecated
    public static CategoryRegistryManager getInstance() {
        if (instance == null) {
            instance = new CategoryRegistryManager();
        }
        return instance;
    }

    @Deprecated
    public static void reset() {
        instance = null;
    }

    @Deprecated
    public static String getLocalRegistryPath() {
        return CategoryRegistryManager.getInstance().getProperties().getLocalRegistryPath();
    }

    @Deprecated
    public static void setLocalRegistryPath(String folder) {
        SemanticProperties properties = new SemanticProperties();
        properties.setLocalRegistryPath(folder);
        instance = new CategoryRegistryManager(properties);
    }

    public SemanticProperties getProperties() {
        return this.properties;
    }

    public SharedDictionary getSharedDictionary() {
        return this.sharedDictionary;
    }

    public void reloadCategoriesFromRegistry() {
        LOGGER.info("Reload categories from local registry.");
        this.getCustomDictionaryHolder().reloadCategoryMetadata();
    }

    @Deprecated
    public Collection<DQCategory> listCategories() {
        return this.getCustomDictionaryHolder().listCategories();
    }

    @Deprecated
    public Collection<DQCategory> listCategories(boolean includeOpenCategories) {
        return this.getCustomDictionaryHolder().listCategories(includeOpenCategories);
    }

    @Deprecated
    public List<DQCategory> listCategories(CategoryType type) {
        return this.getCustomDictionaryHolder().listCategories(type);
    }

    @Deprecated
    public Map<String, DQCategory> getCategoryMetadataMap() {
        return this.getCustomDictionaryHolder().getMetadata();
    }

    @Deprecated
    public DQCategory getCategoryMetadataById(String catId) {
        return this.getCustomDictionaryHolder().getCategoryMetadataById(catId);
    }

    @Deprecated
    public DQCategory getCategoryMetadataByName(String catName) {
        return this.getCustomDictionaryHolder().getCategoryMetadataByName(catName);
    }

    public CustomDictionaryHolder getCustomDictionaryHolder() {
        Object identity;
        Optional tenant = TenancyContextHolder.getContext().getOptionalTenant();
        if (tenant.isPresent() && (identity = ((Tenant)tenant.get()).getIdentity()) != null && !"null".equals(String.valueOf(identity))) {
            return this.getCustomDictionaryHolder(String.valueOf(identity));
        }
        return this.getCustomDictionaryHolder(DEFAULT_TENANT_ID);
    }

    public CustomDictionaryHolder getCustomDictionaryHolder(String tenantID) {
        return this.customDictionaryHolderMap.computeIfAbsent(tenantID, k -> {
            LOGGER.info("Instantiate CustomDictionaryHolder for [{}]", (Object)tenantID);
            return new CustomDictionaryHolder(tenantID, this.properties, this.sharedDictionary);
        });
    }

    @Deprecated
    public String findMostSimilarValue(String input, String categoryName, double similarity) {
        return this.getCustomDictionaryHolder().getDeletableDictionarySnapshot().findMostSimilarValue(input, categoryName, similarity);
    }

    @Deprecated
    public Map<String, Double> findSimilarValues(String input, String categoryName, double similarity) {
        return this.getCustomDictionaryHolder().getDeletableDictionarySnapshot().findSimilarValues(input, categoryName, similarity);
    }

    private void extractSharedCategories() throws IOException, URISyntaxException {
        LOGGER.info("Loading categories from local registry.");
        File categorySubFolder = new File(this.properties.getSharedMetadataURI());
        this.extractSharedIndex(categorySubFolder, "metadata");
        File dictionarySubFolder = new File(this.properties.getSharedDictionaryURI());
        this.extractSharedIndex(dictionarySubFolder, "dictionary");
        File keywordSubFolder = new File(this.properties.getSharedKeywordURI());
        this.extractSharedIndex(keywordSubFolder, "keyword");
        File regexRegistryFile = new File(this.properties.getSharedRegexFileURI());
        this.extractSharedRegex(regexRegistryFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractSharedRegex(File regexRegistryFile) throws IOException {
        if (!regexRegistryFile.exists()) {
            InputStream is = this.getClass().getResourceAsStream("/regex/categorizer.json");
            StringBuilder sb = new StringBuilder();
            for (String line : IOUtils.readLines((InputStream)is)) {
                sb.append(line);
            }
            regexRegistryFile.getParentFile().mkdirs();
            try (FileOutputStream fos = null;){
                JsonNode objNode = this.mapper.readTree(sb.toString());
                JsonNode array = objNode.get("classifiers");
                fos = new FileOutputStream(regexRegistryFile);
                IOUtils.write((String)array.toString(), (OutputStream)fos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractSharedIndex(File destSubFolder, String sourceSubFolder) throws IOException, URISyntaxException {
        Object object = indexExtractionLock;
        synchronized (object) {
            if (!destSubFolder.exists()) {
                boolean baseIndexExtracted = false;
                ArrayList<URL> potentialResources = Collections.list(this.getClass().getClassLoader().getResources(sourceSubFolder));
                for (URL url : potentialResources) {
                    URI uri = url.toURI();
                    LOGGER.info("trying to load base index from {}", (Object)uri.toString());
                    try (Directory srcDir = ClassPathDirectory.open(uri, this.properties);){
                        this.fixExtractionForUnitTests(destSubFolder, uri, srcDir);
                        baseIndexExtracted = true;
                        break;
                    }
                    catch (IllegalArgumentException iae) {
                        LOGGER.debug("could not load base index from {}", (Object)uri, (Object)iae);
                    }
                }
                if (!baseIndexExtracted) {
                    StringBuilder error = new StringBuilder(100);
                    error.append("Could not load base index out of theses locations : [\n");
                    potentialResources.forEach(pr -> error.append('\t').append(pr.toString()).append('\n'));
                    error.append(']');
                    throw new IllegalArgumentException(error.toString());
                }
            }
        }
    }

    private void fixExtractionForUnitTests(File destSubFolder, URI uri, Directory srcDir) throws IOException {
        if (!destSubFolder.exists()) {
            DictionaryUtils.rewriteIndex(srcDir, destSubFolder);
            LOGGER.info("base index loaded from {}", (Object)uri.toString());
        }
    }

    public boolean delete(String tenant) {
        CustomDictionaryHolder removed = this.customDictionaryHolderMap.remove(tenant);
        if (null != removed) {
            return removed.delete();
        }
        LOGGER.warn("Tenant not found {}", (Object)tenant);
        return false;
    }
}

