/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.api;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataquality.semantic.api.DictionaryUtils;
import org.talend.dataquality.semantic.api.LocalDictionaryCache;
import org.talend.dataquality.semantic.api.SemanticProperties;
import org.talend.dataquality.semantic.api.internal.CustomDocumentIndexAccess;
import org.talend.dataquality.semantic.api.internal.CustomMetadataIndexAccess;
import org.talend.dataquality.semantic.api.internal.CustomRegexClassifierAccess;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedCategory;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedClassifier;
import org.talend.dataquality.semantic.index.DictionarySearchMode;
import org.talend.dataquality.semantic.index.LuceneIndex;
import org.talend.dataquality.semantic.model.CategoryType;
import org.talend.dataquality.semantic.model.DQCategory;
import org.talend.dataquality.semantic.model.DQDocument;
import org.talend.dataquality.semantic.snapshot.DeletableDictionarySnapshot;
import org.talend.dataquality.semantic.snapshot.DictionarySnapshot;
import org.talend.dataquality.semantic.snapshot.SharedDictionary;

public class CustomDictionaryHolder
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomDictionaryHolder.class);
    private static final String INITIALIZE_ACCESS = "Initialize %s %s access for [%s]";
    private static final String CUSTOM = "custom";
    private static final String REPUBLISH = "republish";
    private static final String TALEND = "Talend";
    private static final String SYSTEM = "System";
    private Map<String, DQCategory> metadata;
    private Directory dataDictDirectory;
    private UserDefinedClassifier regexClassifier;
    private CustomMetadataIndexAccess customMetadataIndexAccess;
    private CustomDocumentIndexAccess customDocumentIndexAccess;
    private CustomRegexClassifierAccess customRegexClassifierAccess;
    private CustomMetadataIndexAccess customRepublishMetadataIndexAccess;
    private CustomDocumentIndexAccess customRepublishDataDictIndexAccess;
    private CustomRegexClassifierAccess customRepublishRegexClassifierAccess;
    protected LocalDictionaryCache localDictionaryCache;
    private final String tenantID;
    private final SemanticProperties properties;
    private final SharedDictionary sharedDictionary;

    public CustomDictionaryHolder(String tenantID, SemanticProperties properties, SharedDictionary sharedDictionary) {
        this.tenantID = tenantID;
        this.properties = properties;
        this.sharedDictionary = sharedDictionary;
        this.checkCustomFolders(sharedDictionary);
    }

    private void checkCustomFolders(SharedDictionary sharedDictionary) {
        File metadataFolder = new File(this.properties.getIndexFolderPath(this.tenantID, SemanticProperties.IndexType.METADATA));
        if (metadataFolder.exists()) {
            this.ensureMetadataIndexAccess();
            File dataDictFolder = new File(this.properties.getIndexFolderPath(this.tenantID, SemanticProperties.IndexType.DICTIONARY));
            if (dataDictFolder.exists()) {
                this.ensureDocumentDictIndexAccess();
            }
            this.ensureRegexClassifierAccess();
        } else {
            this.metadata = sharedDictionary.getCategoryMetadata();
        }
    }

    public String getTenantID() {
        return this.tenantID;
    }

    @Deprecated
    public Map<String, DQCategory> getMetadata() {
        return this.metadata;
    }

    public Directory getDataDictDirectory() {
        return this.dataDictDirectory;
    }

    public UserDefinedClassifier getRegexClassifier() {
        if (this.regexClassifier == null) {
            return this.sharedDictionary.getRegexClassifier();
        }
        return this.regexClassifier;
    }

    private synchronized void ensureMetadataIndexAccess() {
        if (this.customMetadataIndexAccess == null) {
            LOGGER.info(String.format(INITIALIZE_ACCESS, CUSTOM, "metadata", this.tenantID));
            File folder = this.getIndexFolder(SemanticProperties.IndexType.METADATA);
            try {
                this.customMetadataIndexAccess = new CustomMetadataIndexAccess((Directory)FSDirectory.open((Path)folder.toPath()), this.sharedDictionary);
                this.metadata = this.customMetadataIndexAccess.readCategoryMedatada();
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private File ensureFolderExist(String metadataIndexPath) {
        File folder = new File(metadataIndexPath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return folder;
    }

    private synchronized void ensureDocumentDictIndexAccess() {
        this.ensureMetadataIndexAccess();
        if (this.customDocumentIndexAccess == null) {
            LOGGER.info(String.format(INITIALIZE_ACCESS, CUSTOM, "dictionary", this.tenantID));
            File folder = this.getIndexFolder(SemanticProperties.IndexType.DICTIONARY);
            try {
                this.dataDictDirectory = FSDirectory.open((Path)folder.toPath());
                this.customDocumentIndexAccess = new CustomDocumentIndexAccess(this.dataDictDirectory, this.properties);
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private File getIndexFolder(SemanticProperties.IndexType dictionary) {
        String dataDictIndexPath = this.properties.getIndexFolderPath(this.tenantID, dictionary);
        return this.ensureFolderExist(dataDictIndexPath);
    }

    private synchronized void ensureRepublishDataDictIndexAccess() {
        if (this.customRepublishDataDictIndexAccess == null) {
            LOGGER.info(String.format(INITIALIZE_ACCESS, REPUBLISH, "dictionary", this.tenantID));
            File folder = this.getIndexRepublishFolder(SemanticProperties.IndexType.DICTIONARY);
            try {
                this.customRepublishDataDictIndexAccess = new CustomDocumentIndexAccess((Directory)FSDirectory.open((Path)folder.toPath()), this.properties);
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private File getIndexRepublishFolder(SemanticProperties.IndexType dictionary) {
        String dataDictIndexPath = this.properties.getIndexRepublishFolderPath(this.tenantID, dictionary);
        return this.ensureFolderExist(dataDictIndexPath);
    }

    private synchronized void ensureRepublishMetadataIndexAccess() {
        if (this.customRepublishMetadataIndexAccess == null) {
            LOGGER.info(String.format(INITIALIZE_ACCESS, REPUBLISH, "metadata", this.tenantID));
            File folder = this.getIndexRepublishFolder(SemanticProperties.IndexType.METADATA);
            try {
                this.customRepublishMetadataIndexAccess = new CustomMetadataIndexAccess((Directory)FSDirectory.open((Path)folder.toPath()), this.sharedDictionary);
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void createCategory(DQCategory category) {
        if (CategoryType.REGEX.equals((Object)category.getType())) {
            this.insertOrUpdateRegexCategory(category);
        } else if (CategoryType.DICT.equals((Object)category.getType())) {
            this.ensureDocumentDictIndexAccess();
        }
        category.setModified(Boolean.valueOf(true));
        this.ensureMetadataIndexAccess();
        this.customMetadataIndexAccess.createCategory(category);
        this.finalizeMetadataUpdate();
    }

    public void updateCategory(DQCategory category) {
        if (CategoryType.DICT.equals((Object)category.getType())) {
            this.copyDataDictByCategoryFromSharedDirectory(category.getId());
        } else if (CategoryType.REGEX.equals((Object)category.getType())) {
            this.insertOrUpdateRegexCategory(category);
        }
        DQCategory categoryClone = (DQCategory)SerializationUtils.clone((Serializable)category);
        categoryClone.setModified(Boolean.valueOf(true));
        this.ensureMetadataIndexAccess();
        this.customMetadataIndexAccess.insertOrUpdateCategory(categoryClone);
        this.finalizeMetadataUpdate();
    }

    private void copyDataDictByCategoryFromSharedDirectory(String categoryId) {
        DQCategory dqCat = this.getMetadata().get(categoryId);
        if (dqCat != null && !Boolean.TRUE.equals(dqCat.getModified())) {
            this.ensureDocumentDictIndexAccess();
            this.customDocumentIndexAccess.copyBaseDocumentsFromSharedDirectory(dqCat);
        }
    }

    public void deleteCategory(DQCategory category) {
        DQCategory categoryClone = (DQCategory)SerializationUtils.clone((Serializable)category);
        categoryClone.setDeleted(Boolean.valueOf(true));
        this.ensureMetadataIndexAccess();
        String categoryId = category.getId();
        if (CategoryType.REGEX.equals((Object)category.getType())) {
            this.ensureRegexClassifierAccess();
            this.customRegexClassifierAccess.deleteRegex(categoryId);
        }
        if (this.isSystemCategory(category)) {
            this.customMetadataIndexAccess.insertOrUpdateCategory(categoryClone);
            if (!CategoryType.REGEX.equals((Object)category.getType()) && Boolean.TRUE.equals(category.getModified())) {
                this.ensureDocumentDictIndexAccess();
                this.customDocumentIndexAccess.deleteDocumentsByCategoryId(categoryId);
                this.customDocumentIndexAccess.commitChanges();
            }
        } else {
            this.customMetadataIndexAccess.deleteCategory(categoryClone);
            this.ensureDocumentDictIndexAccess();
            this.customDocumentIndexAccess.deleteDocumentsByCategoryId(categoryId);
            this.customDocumentIndexAccess.commitChanges();
        }
        this.finalizeMetadataUpdate();
    }

    private void finalizeMetadataUpdate() {
        this.customMetadataIndexAccess.commitChanges();
        this.metadata = this.customMetadataIndexAccess.readCategoryMedatada();
    }

    private boolean isSystemCategory(DQCategory category) {
        return TALEND.equals(category.getCreator()) || SYSTEM.equals(category.getCreator());
    }

    public void reloadCategoryMetadata() {
        this.checkCustomFolders(this.sharedDictionary);
        if (this.customMetadataIndexAccess != null) {
            this.metadata = this.customMetadataIndexAccess.readCategoryMedatada();
        }
        if (this.customRegexClassifierAccess != null) {
            this.regexClassifier = this.customRegexClassifierAccess.readUserDefinedClassifier();
        }
    }

    public void updateDataDictDocuments(List<DQDocument> documents) {
        this.ensureDocumentDictIndexAccess();
        this.operationDataDictDocuments(documents, this.customDocumentIndexAccess::insertOrUpdateDocument);
    }

    public void addDataDictDocuments(List<DQDocument> documents) {
        this.ensureDocumentDictIndexAccess();
        this.operationDataDictDocuments(documents, this.customDocumentIndexAccess::createDocument);
    }

    public void deleteDataDictDocuments(List<DQDocument> documents) {
        this.ensureDocumentDictIndexAccess();
        this.operationDataDictDocuments(documents, this.customDocumentIndexAccess::deleteDocument);
    }

    private void operationDataDictDocuments(List<DQDocument> documents, Consumer<List<DQDocument>> function) {
        String categoryId = documents.get(0).getCategory().getId();
        DQCategory category = this.getMetadata().get(categoryId);
        if (category != null && !Boolean.TRUE.equals(category.getModified())) {
            this.updateCategory(category);
        }
        function.accept(documents);
        this.customDocumentIndexAccess.commitChanges();
    }

    void closeRepublishDictionaryAccess() {
        try {
            if (this.customRepublishMetadataIndexAccess != null) {
                this.customRepublishMetadataIndexAccess.close();
            }
            if (this.customRepublishDataDictIndexAccess != null) {
                this.customRepublishDataDictIndexAccess.close();
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.customRepublishMetadataIndexAccess = null;
            this.customRepublishDataDictIndexAccess = null;
            this.customRepublishRegexClassifierAccess = null;
        }
    }

    @Override
    public void close() {
        try {
            this.closeRepublishDictionaryAccess();
            if (null != this.customDocumentIndexAccess) {
                this.customDocumentIndexAccess.close();
            }
            if (null != this.customMetadataIndexAccess) {
                this.customMetadataIndexAccess.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized void ensureRegexClassifierAccess() {
        if (this.customRegexClassifierAccess == null) {
            LOGGER.info(String.format(INITIALIZE_ACCESS, new Object[]{CUSTOM, SemanticProperties.IndexType.REGEX, this.tenantID}));
            this.customRegexClassifierAccess = new CustomRegexClassifierAccess(this, this.properties);
            this.regexClassifier = this.customRegexClassifierAccess.readUserDefinedClassifier();
        }
    }

    private synchronized void ensureRepublishRegexClassifierAccess() {
        if (this.customRepublishRegexClassifierAccess == null) {
            LOGGER.info(String.format(INITIALIZE_ACCESS, new Object[]{REPUBLISH, SemanticProperties.IndexType.REGEX, this.tenantID}));
            this.customRepublishRegexClassifierAccess = new CustomRegexClassifierAccess(this.properties.getIndexRepublishFolderPath(this.tenantID, SemanticProperties.IndexType.REGEX));
        }
    }

    private void insertOrUpdateRegexCategory(DQCategory category) {
        this.ensureRegexClassifierAccess();
        UserDefinedCategory regEx = DictionaryUtils.regexClassifierfromDQCategory(category);
        this.customRegexClassifierAccess.insertOrUpdateRegex(regEx);
        this.regexClassifier = this.customRegexClassifierAccess.readUserDefinedClassifier();
    }

    @Deprecated
    public Collection<DQCategory> listCategories() {
        try (DictionarySnapshot dictionarySnapshot = this.getDictionarySnapshot();){
            Collection<DQCategory> collection = dictionarySnapshot.listCategories(true);
            return collection;
        }
    }

    @Deprecated
    public Collection<DQCategory> listCategories(boolean includeOpenCategories) {
        try (DictionarySnapshot dictionarySnapshot = this.getDictionarySnapshot();){
            Collection<DQCategory> collection = dictionarySnapshot.listCategories(includeOpenCategories);
            return collection;
        }
    }

    @Deprecated
    public List<DQCategory> listCategories(CategoryType type) {
        try (DictionarySnapshot dictionarySnapshot = this.getDictionarySnapshot();){
            List<DQCategory> list = dictionarySnapshot.listCategories(type);
            return list;
        }
    }

    @Deprecated
    public DQCategory getCategoryMetadataById(String catId) {
        try (DictionarySnapshot dictionarySnapshot = this.getDictionarySnapshot();){
            DQCategory dQCategory = dictionarySnapshot.getCategoryMetadataById(catId);
            return dQCategory;
        }
    }

    @Deprecated
    public DQCategory getCategoryMetadataByName(String catName) {
        try (DictionarySnapshot dictionarySnapshot = this.getDictionarySnapshot();){
            DQCategory dQCategory = dictionarySnapshot.getCategoryMetadataByName(catName);
            return dQCategory;
        }
    }

    public IndexWriter getMetadataIndexWriter() throws IOException {
        this.ensureMetadataIndexAccess();
        return this.customMetadataIndexAccess.getWriter();
    }

    public IndexWriter getDataDictIndexWriter() throws IOException {
        this.ensureDocumentDictIndexAccess();
        return this.customDocumentIndexAccess.getWriter();
    }

    public void beforeRepublish() {
        this.ensureRepublishMetadataIndexAccess();
        for (DQCategory category : this.customRepublishMetadataIndexAccess.readCategoryMedatada().values()) {
            category.setDeleted(Boolean.valueOf(true));
            this.customRepublishMetadataIndexAccess.insertOrUpdateCategory(category);
        }
    }

    public void republishDataDictDocuments(List<DQDocument> documents) {
        this.ensureRepublishDataDictIndexAccess();
        this.customRepublishDataDictIndexAccess.createDocument(documents);
    }

    @Deprecated
    public void republishCategory(DQCategory category) {
        this.republishCategories(Collections.singletonList(category));
    }

    public void republishCategories(List<DQCategory> categories) {
        this.ensureRepublishMetadataIndexAccess();
        for (DQCategory category : categories) {
            category.setModified(Boolean.valueOf(this.isModifiedByUser(category)));
            if (this.sharedDictionary.getCategoryMetadata().containsKey((Object)category.getId())) {
                this.customRepublishMetadataIndexAccess.insertOrUpdateCategory(category);
            } else {
                this.customRepublishMetadataIndexAccess.createCategory(category);
            }
            if (!CategoryType.REGEX.equals((Object)category.getType())) continue;
            this.republishRegexCategory(category);
        }
        this.customRepublishMetadataIndexAccess.commitChanges();
    }

    private boolean isModifiedByUser(DQCategory category) {
        boolean isSystem = category.getLastModifier() == null || TALEND.equals(category.getLastModifier()) || SYSTEM.equals(category.getLastModifier());
        return !isSystem;
    }

    private void republishRegexCategory(DQCategory category) {
        this.ensureRepublishRegexClassifierAccess();
        UserDefinedCategory regEx = DictionaryUtils.regexClassifierfromDQCategory(category);
        this.customRepublishRegexClassifierAccess.insertOrUpdateRegex(regEx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void publishDirectory() throws IOException {
        this.closeRepublishDictionaryAccess();
        File republishIndexes = new File(this.properties.getRepublishFolder(this.tenantID));
        File productionIndexes = new File(this.properties.getProductionFolder(this.tenantID));
        File backup = new File(productionIndexes.getPath() + ".old");
        if (!backup.exists() && republishIndexes.exists()) {
            if (productionIndexes.exists()) {
                try {
                    LOGGER.info("[Post Republish] backup prod");
                    FileUtils.copyDirectory((File)productionIndexes, (File)backup);
                    this.copyStagingToProd(backup, productionIndexes);
                }
                catch (IOException exception) {
                    LOGGER.error(exception.getMessage(), (Throwable)exception);
                }
                finally {
                    LOGGER.info("[Post Republish] delete backup");
                    FileUtils.deleteDirectory((File)backup);
                }
            } else {
                FileUtils.copyDirectory((File)republishIndexes, (File)productionIndexes);
            }
            LOGGER.info("[Post Republish] delete staging contents");
            FileUtils.deleteDirectory((File)republishIndexes);
            this.reloadCategoryMetadata();
        }
    }

    private void copyStagingToProd(File backup, File productionIndexes) throws IOException {
        try {
            File regexFile;
            File dictionaryFolder;
            LOGGER.info("[Post Republish] insert staging directory into prod");
            File metadataFolder = new File(this.properties.getIndexRepublishFolderPath(this.tenantID, SemanticProperties.IndexType.METADATA));
            if (metadataFolder.exists()) {
                this.ensureMetadataIndexAccess();
                this.customMetadataIndexAccess.copyStagingContent(metadataFolder.getAbsolutePath());
            }
            if ((dictionaryFolder = new File(this.properties.getIndexRepublishFolderPath(this.tenantID, SemanticProperties.IndexType.DICTIONARY))).exists()) {
                this.ensureDocumentDictIndexAccess();
                this.customDocumentIndexAccess.copyStagingContent(dictionaryFolder.getAbsolutePath());
            }
            if ((regexFile = new File(this.properties.getIndexRepublishFolderPath(this.tenantID, SemanticProperties.IndexType.REGEX))).exists()) {
                this.ensureRegexClassifierAccess();
                this.customRegexClassifierAccess.copyStagingContent(regexFile.getAbsolutePath());
            }
        }
        catch (IOException exception) {
            LOGGER.error(exception.getMessage(), (Throwable)exception);
            FileUtils.cleanDirectory((File)productionIndexes);
            FileUtils.copyDirectory((File)backup, (File)productionIndexes);
        }
    }

    @Deprecated
    public DictionarySnapshot getDictionarySnapshot() {
        return new DictionarySnapshot(this.getMetadata(), new LuceneIndex(this.sharedDictionary.getDataDictDirectory(), DictionarySearchMode.MATCH_SEMANTIC_DICTIONARY), this.getDataDictDirectory() == null ? null : new LuceneIndex(this.getDataDictDirectory(), DictionarySearchMode.MATCH_SEMANTIC_DICTIONARY), new LuceneIndex(this.sharedDictionary.getKeywordDirectory(), DictionarySearchMode.MATCH_SEMANTIC_KEYWORD), this.getRegexClassifier());
    }

    @Deprecated
    public DeletableDictionarySnapshot getDeletableDictionarySnapshot() {
        return new DeletableDictionarySnapshot(this.getMetadata(), new LuceneIndex(this.sharedDictionary.getDataDictDirectory(), DictionarySearchMode.MATCH_SEMANTIC_DICTIONARY), this.getDataDictDirectory() == null ? null : new LuceneIndex(this.getDataDictDirectory(), DictionarySearchMode.MATCH_SEMANTIC_DICTIONARY), new LuceneIndex(this.sharedDictionary.getKeywordDirectory(), DictionarySearchMode.MATCH_SEMANTIC_KEYWORD), this.getRegexClassifier(), this.properties.getTenantFolder(this.tenantID));
    }

    public boolean delete() {
        LOGGER.info("Delete data for tenant " + this.tenantID);
        this.close();
        File rootFolder = new File(this.properties.getTenantFolder(this.tenantID));
        try {
            FileUtils.deleteDirectory((File)rootFolder);
            return true;
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

