/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.api;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataquality.semantic.api.CategoryMetadataUtils;
import org.talend.dataquality.semantic.api.SemanticProperties;
import org.talend.dataquality.semantic.api.internal.CustomRegexClassifierAccess;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedClassifier;
import org.talend.dataquality.semantic.index.DictionarySearchMode;
import org.talend.dataquality.semantic.index.LuceneIndex;
import org.talend.dataquality.semantic.model.DQCategory;
import org.talend.dataquality.semantic.snapshot.DeletableDictionarySnapshot;
import org.talend.dataquality.semantic.snapshot.SharedDictionary;

public class DeletableDictionarySnapshotOpener {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SemanticProperties properties;
    private final SharedDictionary sharedDictionary;

    public DeletableDictionarySnapshotOpener(SemanticProperties properties, SharedDictionary sharedDictionary) {
        this.properties = properties;
        this.sharedDictionary = sharedDictionary;
    }

    public DeletableDictionarySnapshot openDeletableDictionarySnapshot(String tenantId) {
        LuceneIndex shared = new LuceneIndex(this.sharedDictionary.getDataDictDirectory(), DictionarySearchMode.MATCH_SEMANTIC_DICTIONARY);
        LuceneIndex keyword = new LuceneIndex(this.sharedDictionary.getKeywordDirectory(), DictionarySearchMode.MATCH_SEMANTIC_KEYWORD);
        LuceneIndex customDataDict = this.openDataDictDirectory(tenantId).map(it -> new LuceneIndex((Directory)it, DictionarySearchMode.MATCH_SEMANTIC_DICTIONARY)).orElse(null);
        UserDefinedClassifier regexClassifier = this.getRegexClassifier(tenantId);
        return new DeletableDictionarySnapshot(this.getMetadata(tenantId), shared, customDataDict, keyword, regexClassifier, this.properties.getTenantFolder(tenantId));
    }

    private UserDefinedClassifier getRegexClassifier(String tenantId) {
        File regexFile = new File(this.properties.getIndexFolderPath(tenantId, SemanticProperties.IndexType.REGEX));
        if (regexFile.exists()) {
            return new CustomRegexClassifierAccess(regexFile).readUserDefinedClassifier();
        }
        return this.sharedDictionary.getRegexClassifier();
    }

    private Optional<Directory> openDataDictDirectory(String tenantId) {
        File folder = new File(this.properties.getIndexFolderPath(tenantId, SemanticProperties.IndexType.DICTIONARY));
        if (folder.exists()) {
            try {
                return Optional.of(FSDirectory.open((Path)folder.toPath()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return Optional.empty();
    }

    private Map<String, DQCategory> getMetadata(String tenantId) {
        File metadataFolder = new File(this.properties.getIndexFolderPath(tenantId, SemanticProperties.IndexType.METADATA));
        if (metadataFolder.exists()) {
            return this.loadMetadata(metadataFolder);
        }
        return this.sharedDictionary.getCategoryMetadata();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, DQCategory> loadMetadata(File folder) {
        try (FSDirectory directory = FSDirectory.open((Path)folder.toPath());){
            Map<String, DQCategory> map = CategoryMetadataUtils.loadMetadataFromIndex((Directory)directory);
            return map;
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

