/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.WildcardQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataquality.semantic.api.DictionaryUtils;
import org.talend.dataquality.semantic.exception.DQSemanticRuntimeException;
import org.talend.dataquality.semantic.index.DictionarySearcher;
import org.talend.dataquality.semantic.model.DQCategory;
import org.talend.dataquality.semantic.model.DQDocument;
import org.talend.dataquality.semantic.snapshot.DictionarySnapshot;

public class LocalDictionaryCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalDictionaryCache.class);
    private final SearcherManager sharedSearcherManager;
    private SearcherManager customSearcherManager;
    private final DictionarySnapshot dictionarySnapshot;

    public LocalDictionaryCache(DictionarySnapshot dictionarySnapshot) {
        this.dictionarySnapshot = dictionarySnapshot;
        this.sharedSearcherManager = dictionarySnapshot.getSharedDataDict().getSearcher().getSearcherManager();
        this.initCustomDirectory();
    }

    private void initCustomDirectory() {
        if (this.dictionarySnapshot.getCustomDataDict() != null) {
            this.customSearcherManager = this.dictionarySnapshot.getCustomDataDict().getSearcher().getSearcherManager();
        }
    }

    private List<DQDocument> dqDocListFromTopDocs(DQCategory category, TopDocs docs, boolean searchInCustom) throws IOException {
        SearcherManager searcherManager = this.getSearcherManager(searchInCustom);
        if (searchInCustom) {
            searcherManager.maybeRefresh();
        }
        IndexSearcher searcher = (IndexSearcher)searcherManager.acquire();
        IndexReader reader = searcher.getIndexReader();
        ArrayList<DQDocument> dqDocList = new ArrayList<DQDocument>();
        for (ScoreDoc scoreDoc : docs.scoreDocs) {
            Document luceneDoc = reader.document(scoreDoc.doc);
            DQDocument dqDoc = DictionaryUtils.dictionaryEntryFromDocument(luceneDoc, category);
            dqDocList.add(dqDoc);
        }
        searcherManager.release((Object)searcher);
        return dqDocList;
    }

    public List<DQDocument> listDocuments(String categoryName, int offset, int n) {
        try {
            DQCategory dqCat = this.dictionarySnapshot.getCategoryMetadataByName(categoryName);
            if (null == dqCat) {
                throw new DQSemanticRuntimeException("Category " + categoryName + " not found");
            }
            boolean isCategoryModified = dqCat.getModified();
            TopDocs docs = this.sendListDocumentsQuery(dqCat.getId(), offset, n, isCategoryModified);
            return this.dqDocListFromTopDocs(dqCat, docs, isCategoryModified);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private Query getListDocumentsQuery(String categoryId) {
        return new TermQuery(new Term("catid", categoryId));
    }

    private TopDocs sendListDocumentsQuery(String categoryId, int offset, int n, boolean searchInCustom) throws IOException {
        TopDocs result;
        SearcherManager searcherManager = this.getSearcherManager(searchInCustom);
        if (searchInCustom) {
            searcherManager.maybeRefresh();
        }
        IndexSearcher searcher = (IndexSearcher)searcherManager.acquire();
        if (offset <= 0) {
            result = searcher.search(this.getListDocumentsQuery(categoryId), n);
        } else {
            TopDocs topDocs = searcher.search(this.getListDocumentsQuery(categoryId), offset + n);
            TermQuery q = new TermQuery(new Term("catid", categoryId));
            result = searcher.searchAfter(topDocs.scoreDocs[(int)Math.min(topDocs.totalHits.value, (long)offset) - 1], (Query)q, n);
        }
        searcherManager.release((Object)searcher);
        return result;
    }

    public Set<String> suggestValues(String categoryName, String input) {
        return this.suggestValues(categoryName, input, 100);
    }

    public Set<String> suggestValues(String categoryName, String input, int num) {
        DQCategory dqCat;
        String trimmedInput;
        if (input != null && (trimmedInput = input.trim()).length() >= 2 && (dqCat = this.dictionarySnapshot.getCategoryMetadataByName(categoryName)) != null) {
            boolean isCategoryModified = dqCat.getModified();
            Set<String> values = this.doSuggestValues(categoryName, trimmedInput, num, true, isCategoryModified);
            return values.isEmpty() ? this.doSuggestValues(categoryName, trimmedInput, num, false, isCategoryModified) : values;
        }
        return Collections.emptySet();
    }

    private Set<String> doSuggestValues(String categoryName, String input, int num, boolean isPrefixSearch, boolean searchCustomIndex) {
        TreeSet<String> results = new TreeSet<String>();
        try {
            SearcherManager searcherManager = this.getSearcherManager(searchCustomIndex);
            if (searcherManager != null) {
                if (searchCustomIndex) {
                    searcherManager.maybeRefresh();
                }
                IndexSearcher searcher = (IndexSearcher)searcherManager.acquire();
                String jointInput = DictionarySearcher.getJointTokens(input);
                String queryString = isPrefixSearch ? jointInput + "*" : "*" + jointInput + "*";
                BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
                TermQuery catQuery = new TermQuery(new Term("word", categoryName));
                queryBuilder.add((Query)catQuery, BooleanClause.Occur.MUST);
                WildcardQuery wildcardQuery = new WildcardQuery(new Term("synterm", queryString));
                queryBuilder.add((Query)wildcardQuery, BooleanClause.Occur.MUST);
                TopDocs topDocs = searcher.search((Query)queryBuilder.build(), num);
                for (int i = 0; i < topDocs.scoreDocs.length; ++i) {
                    Document doc = searcher.doc(topDocs.scoreDocs[i].doc);
                    this.searchForSuggestions(doc, isPrefixSearch, input, jointInput, results);
                }
                searcherManager.release((Object)searcher);
            }
        }
        catch (IOException e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    private void searchForSuggestions(Document doc, boolean isPrefixSearch, String input, String jointInput, Set<String> results) {
        IndexableField[] fields;
        for (IndexableField f : fields = doc.getFields("raw")) {
            String str = f.stringValue();
            String jointStr = DictionarySearcher.getJointTokens(str);
            if ((!isPrefixSearch || !this.inputStartsWithStr(input, jointInput, str, jointStr)) && !this.inputContainsStr(input, jointInput, str, jointStr)) continue;
            results.add(str);
        }
    }

    private boolean inputStartsWithStr(String input, String jointInput, String str, String jointStr) {
        return StringUtils.startsWithIgnoreCase((CharSequence)str, (CharSequence)input) || StringUtils.startsWithIgnoreCase((CharSequence)jointStr, (CharSequence)jointInput);
    }

    private boolean inputContainsStr(String input, String jointInput, String str, String jointStr) {
        return StringUtils.containsIgnoreCase((CharSequence)str, (CharSequence)input) || StringUtils.containsIgnoreCase((CharSequence)jointStr, (CharSequence)jointInput);
    }

    private SearcherManager getSearcherManager(boolean searchCustomIndex) {
        if (searchCustomIndex) {
            if (this.customSearcherManager == null) {
                this.initCustomDirectory();
            }
            return this.customSearcherManager;
        }
        return this.sharedSearcherManager;
    }
}

