/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.api;

import java.io.File;
import java.net.URI;
import java.nio.file.Paths;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SemanticProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(SemanticProperties.class);
    private static final String DEFAULT_LOCAL_REGISTRY_PATH = System.getProperty("user.home") + "/.talend/dataquality/semantic";
    private static final String SHARED_FOLDER_NAME = "shared";
    private static final String PRODUCTION_FOLDER_NAME = "prod";
    private static final String REPUBLISH_FOLDER_NAME = "republish";
    public static final String METADATA_SUBFOLDER_NAME = "metadata";
    public static final String DICTIONARY_SUBFOLDER_NAME = "dictionary";
    public static final String KEYWORD_SUBFOLDER_NAME = "keyword";
    private static final String REGEX_SUBFOLDER_NAME = "regex";
    private static final String REGEX_CATEGORIZER_FILE_NAME = "categorizer.json";
    public static final String REGEX_CATEGORIZER_CLASSPATH = "/regex/categorizer.json";
    private String localRegistryPath;

    public SemanticProperties() {
        this(DEFAULT_LOCAL_REGISTRY_PATH);
    }

    public SemanticProperties(String localRegistryPath) {
        this.setLocalRegistryPath(localRegistryPath);
    }

    public String getLocalRegistryPath() {
        return this.localRegistryPath;
    }

    public void setLocalRegistryPath(String localRegistryPath) {
        if (localRegistryPath != null && localRegistryPath.trim().length() > 0) {
            this.localRegistryPath = localRegistryPath;
        } else {
            LOGGER.warn("Cannot set an empty path as local registry location. Use default one: " + localRegistryPath);
        }
        this.localRegistryPath = localRegistryPath;
    }

    public URI getSharedMetadataURI() {
        return Paths.get(this.getSharedFolder(), METADATA_SUBFOLDER_NAME).toUri();
    }

    public URI getSharedDictionaryURI() {
        return Paths.get(this.getSharedFolder(), DICTIONARY_SUBFOLDER_NAME).toUri();
    }

    public URI getSharedKeywordURI() {
        return Paths.get(this.getSharedFolder(), KEYWORD_SUBFOLDER_NAME).toUri();
    }

    public URI getSharedRegexFileURI() {
        return Paths.get(this.getSharedFolder(), REGEX_SUBFOLDER_NAME, REGEX_CATEGORIZER_FILE_NAME).toUri();
    }

    public String getIndexFolderPath(String tenantID, IndexType index) {
        return this.getIndexFolderPath(tenantID, true, index.path);
    }

    public String getIndexRepublishFolderPath(String tenantID, IndexType index) {
        return this.getIndexFolderPath(tenantID, false, index.path);
    }

    private String getIndexFolderPath(String tenantID, boolean isProduction, String indexName) {
        String folder = isProduction ? this.getProductionFolder(tenantID) : this.getRepublishFolder(tenantID);
        return this.pathBuilder(folder, indexName);
    }

    public String getRepublishFolder(String tenantID) {
        return this.pathBuilder(this.getTenantFolder(tenantID), REPUBLISH_FOLDER_NAME);
    }

    public String getProductionFolder(String tenantID) {
        return this.pathBuilder(this.getTenantFolder(tenantID), PRODUCTION_FOLDER_NAME);
    }

    public String getTenantFolder(String tenantID) {
        return this.pathBuilder(this.localRegistryPath, tenantID);
    }

    public String getSharedFolder() {
        return this.pathBuilder(this.localRegistryPath, SHARED_FOLDER_NAME, PRODUCTION_FOLDER_NAME);
    }

    private String pathBuilder(String ... paths) {
        StringJoiner joiner = new StringJoiner(File.separator);
        for (String p : paths) {
            joiner.add(p);
        }
        return joiner.toString();
    }

    public static enum IndexType {
        DICTIONARY("dictionary"),
        KEYWORD("keyword"),
        METADATA("metadata"),
        REGEX("regex" + File.separator + "categorizer.json");

        private String path;

        private IndexType(String path) {
            this.path = path;
        }
    }
}

