/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.api.internal;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractCustomIndexAccess
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCustomIndexAccess.class);
    private final Analyzer analyzer = new StandardAnalyzer(CharArraySet.EMPTY_SET);
    protected Directory directory;
    protected IndexWriter luceneWriter;
    protected DirectoryReader luceneReader;
    protected SearcherManager mgr;

    public AbstractCustomIndexAccess(Directory directory) {
        this.directory = directory;
    }

    protected DirectoryReader getReader() throws IOException {
        if (this.luceneReader == null) {
            this.luceneReader = DirectoryReader.open((Directory)this.directory);
        }
        return this.luceneReader;
    }

    public synchronized IndexWriter getWriter() throws IOException {
        if (this.luceneWriter == null) {
            IndexWriterConfig iwc = new IndexWriterConfig(this.analyzer);
            this.luceneWriter = new IndexWriter(this.directory, iwc);
        }
        return this.luceneWriter;
    }

    @Deprecated
    public void deleteAll() {
        LOGGER.info("delete all content");
        try {
            this.getWriter().deleteAll();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.mgr != null) {
            this.mgr.close();
        }
        if (this.luceneWriter != null) {
            try {
                this.luceneWriter.commit();
                this.luceneWriter.close();
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        if (this.luceneReader != null) {
            try {
                this.luceneReader.close();
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        if (this.directory != null) {
            this.directory.close();
        }
    }

    public void commitChanges() {
        try {
            IndexWriter writer = this.getWriter();
            if (writer != null) {
                writer.forceMerge(Integer.MAX_VALUE);
                writer.commit();
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void copyStagingContent(String srcPath) throws IOException {
        try (FSDirectory dir = FSDirectory.open((Path)Paths.get(srcPath, new String[0]));){
            IndexWriter writer = this.getWriter();
            writer.deleteAll();
            writer.addIndexes(new Directory[]{dir});
            writer.commit();
        }
    }
}

