/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.api.internal;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataquality.semantic.api.CustomDictionaryHolder;
import org.talend.dataquality.semantic.api.SemanticProperties;
import org.talend.dataquality.semantic.classifier.ISubCategory;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedClassifier;

public class CustomRegexClassifierAccess {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomRegexClassifierAccess.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final File regExFile;

    public CustomRegexClassifierAccess(CustomDictionaryHolder holder, SemanticProperties properties) {
        String regexFilePath = properties.getIndexFolderPath(holder.getTenantID(), SemanticProperties.IndexType.REGEX);
        this.regExFile = new File(regexFilePath);
        if (!this.regExFile.exists()) {
            this.writeRegExs(new ArrayList<ISubCategory>(holder.getRegexClassifier().getClassifiers()));
        }
    }

    public CustomRegexClassifierAccess(String regexFilePath) {
        this(new File(regexFilePath));
    }

    public CustomRegexClassifierAccess(File regExFile) {
        this.regExFile = regExFile;
        if (!regExFile.exists()) {
            this.writeRegExs(new ArrayList<ISubCategory>());
        }
    }

    public void insertOrUpdateRegex(ISubCategory regEx) {
        LOGGER.debug("insertOrUpdateRegex: " + regEx);
        List<ISubCategory> regExs = this.getRegExs();
        if (regExs == null) {
            regExs = new ArrayList<ISubCategory>();
        } else {
            regExs.removeIf(expression -> expression.getId().equals(regEx.getId()));
        }
        regExs.add(regEx);
        this.writeRegExs(regExs);
    }

    public void deleteRegex(String regexId) {
        LOGGER.debug("deleteRegex: " + regexId);
        List<ISubCategory> regExs = this.getRegExs();
        if (regExs != null) {
            regExs.removeIf(expression -> regexId.equals(expression.getId()));
            this.writeRegExs(regExs);
        }
    }

    private void writeRegExs(List<ISubCategory> regExs) {
        if (!this.regExFile.exists()) {
            this.regExFile.getParentFile().mkdirs();
        }
        try {
            this.mapper.writerWithDefaultPrettyPrinter().writeValue(this.regExFile, regExs);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public List<ISubCategory> getRegExs() {
        List regExs = null;
        try {
            regExs = (List)this.mapper.readValue(this.regExFile, (TypeReference)new TypeReference<List<ISubCategory>>(){});
        }
        catch (JsonMappingException jsonE) {
            if (!jsonE.getMessage().contains("No content")) {
                LOGGER.error(jsonE.getMessage(), (Throwable)jsonE);
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return regExs;
    }

    public UserDefinedClassifier readUserDefinedClassifier() {
        UserDefinedClassifier udc = new UserDefinedClassifier();
        List<ISubCategory> regExs = this.getRegExs();
        for (ISubCategory cat : regExs) {
            udc.addSubCategory(cat);
        }
        return udc;
    }

    public void copyStagingContent(String srcPath) throws IOException {
        FileUtils.copyFile((File)new File(srcPath), (File)this.regExFile);
    }
}

