/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.broadcast;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataquality.semantic.broadcast.BroadcastDocumentObject;
import org.talend.dataquality.semantic.broadcast.BroadcastUtils;
import org.talend.dataquality.semantic.model.CategoryType;
import org.talend.dataquality.semantic.model.DQCategory;

public class BroadcastIndexObject
implements Serializable {
    private static final long serialVersionUID = 7350930198992853600L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BroadcastIndexObject.class);
    private List<BroadcastDocumentObject> documentList;
    private transient ByteBuffersDirectory ramDirectory;

    public BroadcastIndexObject() {
    }

    public BroadcastIndexObject(List<BroadcastDocumentObject> documentList) {
        this.documentList = documentList;
    }

    public BroadcastIndexObject(Directory inputDirectory, Collection<DQCategory> categories) {
        this(inputDirectory, false, categories);
    }

    public BroadcastIndexObject(Directory inputDirectory, Set<String> categories) {
        try {
            this.documentList = BroadcastUtils.readDocumentsFromIndex(inputDirectory, categories);
        }
        catch (IOException e) {
            this.documentList = Collections.emptyList();
            LOGGER.error("Unable to read synonym index.", (Throwable)e);
        }
    }

    public BroadcastIndexObject(Directory inputDirectory, boolean includeOpenCategories, Collection<DQCategory> categories) {
        try {
            if (includeOpenCategories) {
                this.documentList = BroadcastUtils.readDocumentsFromIndex(inputDirectory);
            } else {
                HashSet<String> catIds = new HashSet<String>();
                for (DQCategory dqCat : categories) {
                    if (!CategoryType.DICT.equals((Object)dqCat.getType())) continue;
                    catIds.add(dqCat.getId());
                }
                this.documentList = BroadcastUtils.readDocumentsFromIndex(inputDirectory, catIds);
            }
        }
        catch (IOException e) {
            this.documentList = Collections.emptyList();
            LOGGER.error("Unable to read synonym index.", (Throwable)e);
        }
    }

    public List<BroadcastDocumentObject> getDocumentList() {
        return this.documentList;
    }

    public void setDocumentList(List<BroadcastDocumentObject> documentList) {
        this.documentList = documentList;
    }

    public synchronized Directory asDirectory() {
        if (this.ramDirectory == null) {
            try {
                this.ramDirectory = BroadcastUtils.createByteBuffersDirectoryFromDocuments(this.documentList);
            }
            catch (IOException e) {
                LOGGER.error("Unable to rebuild the broadcast dictionary.", (Throwable)e);
            }
        }
        return this.ramDirectory;
    }
}

