/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.broadcast;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataquality.semantic.broadcast.DQCategoryForValidation;
import org.talend.dataquality.semantic.model.DQCategory;

public class BroadcastMetadataObject
implements Serializable {
    private static final long serialVersionUID = 6228494634405067399L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BroadcastMetadataObject.class);
    private Map<String, DQCategoryForValidation> metadata;

    public BroadcastMetadataObject() {
    }

    public BroadcastMetadataObject(Map<String, DQCategory> dqCategoryMap) {
        this.metadata = new HashMap<String, DQCategoryForValidation>();
        dqCategoryMap.values().forEach(value -> {
            DQCategoryForValidation dqCategoryForValidation = new DQCategoryForValidation();
            try {
                PropertyUtils.copyProperties((Object)dqCategoryForValidation, (Object)value);
                List sourceChildren = value.getChildren();
                if (!CollectionUtils.isEmpty((Collection)sourceChildren)) {
                    ArrayList<DQCategoryForValidation> copyChildren = new ArrayList<DQCategoryForValidation>();
                    for (DQCategory child : sourceChildren) {
                        DQCategoryForValidation copyChild = new DQCategoryForValidation();
                        PropertyUtils.copyProperties((Object)copyChild, (Object)child);
                        copyChildren.add(copyChild);
                    }
                    dqCategoryForValidation.setChildren(copyChildren);
                }
                this.metadata.put(value.getId(), dqCategoryForValidation);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        });
    }

    @JsonIgnore
    public Map<String, DQCategory> getDQCategoryMap() {
        HashMap<String, DQCategory> dqCategoryMap = new HashMap<String, DQCategory>();
        this.metadata.values().forEach(value -> {
            try {
                DQCategory dqCategory = new DQCategory();
                PropertyUtils.copyProperties((Object)dqCategory, (Object)value);
                dqCategoryMap.put(value.getId(), dqCategory);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        });
        return dqCategoryMap;
    }

    public Map<String, DQCategoryForValidation> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, DQCategoryForValidation> metadata) {
        this.metadata = metadata;
    }
}

