/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.broadcast;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.talend.dataquality.semantic.api.DictionaryUtils;
import org.talend.dataquality.semantic.broadcast.BroadcastDocumentObject;
import org.talend.dataquality.semantic.index.DictionarySearcher;

class BroadcastUtils {
    private BroadcastUtils() {
    }

    static List<BroadcastDocumentObject> readDocumentsFromIndex(Directory indexDir) throws IOException {
        ArrayList<BroadcastDocumentObject> dictionaryObject = new ArrayList<BroadcastDocumentObject>();
        try (DirectoryReader reader = DirectoryReader.open((Directory)indexDir);){
            Set<Integer> deletedDocs = DictionaryUtils.getDeletedDocs(indexDir);
            for (int i = 0; i < reader.maxDoc(); ++i) {
                if (deletedDocs.contains(i)) continue;
                Document doc = reader.document(i);
                String catId = doc.getField("catid").stringValue();
                HashSet<String> valueSet = new HashSet<String>();
                for (IndexableField syntermField : doc.getFields("raw")) {
                    valueSet.add(syntermField.stringValue());
                }
                dictionaryObject.add(new BroadcastDocumentObject(catId, valueSet));
            }
        }
        return dictionaryObject;
    }

    static List<BroadcastDocumentObject> readDocumentsFromIndex(Directory indexDir, Set<String> selectedCategoryIds) throws IOException {
        ArrayList<BroadcastDocumentObject> dictionaryObject = new ArrayList<BroadcastDocumentObject>();
        if (indexDir != null) {
            BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
            for (String a : selectedCategoryIds) {
                queryBuilder.add((Query)new TermQuery(new Term("catid", a)), BooleanClause.Occur.SHOULD);
            }
            try (DirectoryReader reader = DirectoryReader.open((Directory)indexDir);){
                IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
                TopDocs topDocs = searcher.search((Query)queryBuilder.build(), Integer.MAX_VALUE);
                for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                    Document doc = searcher.doc(scoreDoc.doc);
                    HashSet<String> valueSet = new HashSet<String>();
                    for (IndexableField syntermField : doc.getFields("raw")) {
                        valueSet.add(syntermField.stringValue());
                    }
                    dictionaryObject.add(new BroadcastDocumentObject(doc.getField("catid").stringValue(), valueSet));
                }
            }
        }
        return dictionaryObject;
    }

    static ByteBuffersDirectory createByteBuffersDirectoryFromDocuments(List<BroadcastDocumentObject> dictionaryObject) throws IOException {
        ByteBuffersDirectory ramDirectory = new ByteBuffersDirectory();
        IndexWriterConfig writerConfig = new IndexWriterConfig((Analyzer)new StandardAnalyzer(CharArraySet.EMPTY_SET));
        try (IndexWriter writer = new IndexWriter((Directory)ramDirectory, writerConfig);){
            for (BroadcastDocumentObject objectDoc : dictionaryObject) {
                writer.addDocument((Iterable)BroadcastUtils.createLuceneDocumentFromObject(objectDoc));
            }
            writer.commit();
        }
        return ramDirectory;
    }

    private static Document createLuceneDocumentFromObject(BroadcastDocumentObject objectDoc) {
        Document indexDoc = new Document();
        FieldType ftSyn = new FieldType();
        ftSyn.setStored(false);
        ftSyn.setIndexOptions(IndexOptions.DOCS);
        ftSyn.setOmitNorms(true);
        ftSyn.freeze();
        indexDoc.add((IndexableField)new StringField("catid", objectDoc.getCategory(), Field.Store.YES));
        for (String value : objectDoc.getValueSet()) {
            indexDoc.add((IndexableField)new Field("raw", (CharSequence)value, (IndexableFieldType)DictionaryUtils.FIELD_TYPE_RAW_VALUE));
            indexDoc.add((IndexableField)new StringField("synterm", DictionarySearcher.getJointTokens(value), Field.Store.NO));
        }
        return indexDoc;
    }
}

