/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.classifier.custom;

import com.google.re2j.Pattern;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CompiledRegexPatternCache {
    private static Map<String, java.util.regex.Pattern> javaCaseInsensitivePatternMap = new ConcurrentHashMap<String, java.util.regex.Pattern>();
    private static Map<String, java.util.regex.Pattern> javaCaseSensitivePatternMap = new ConcurrentHashMap<String, java.util.regex.Pattern>();
    private static Map<String, Pattern> re2jCaseInsensitivePatternMap = new ConcurrentHashMap<String, Pattern>();
    private static Map<String, Pattern> re2jCaseSensitivePatternMap = new ConcurrentHashMap<String, Pattern>();

    private CompiledRegexPatternCache() {
    }

    public static java.util.regex.Pattern getJavaCaseInsensitivePattern(String patternString) {
        java.util.regex.Pattern compiledPattern = javaCaseInsensitivePatternMap.get(patternString);
        if (compiledPattern == null) {
            compiledPattern = java.util.regex.Pattern.compile(patternString, 2);
            javaCaseInsensitivePatternMap.put(patternString, compiledPattern);
        }
        return compiledPattern;
    }

    public static java.util.regex.Pattern getJavaCaseSensitivePattern(String patternString) {
        java.util.regex.Pattern compiledPattern = javaCaseSensitivePatternMap.get(patternString);
        if (compiledPattern == null) {
            compiledPattern = java.util.regex.Pattern.compile(patternString);
            javaCaseSensitivePatternMap.put(patternString, compiledPattern);
        }
        return compiledPattern;
    }

    public static Pattern getRe2jCaseInsensitivePattern(String patternString) {
        Pattern compiledPattern = re2jCaseInsensitivePatternMap.get(patternString);
        if (compiledPattern == null) {
            compiledPattern = Pattern.compile((String)patternString, (int)1);
            re2jCaseInsensitivePatternMap.put(patternString, compiledPattern);
        }
        return compiledPattern;
    }

    public static Pattern getRe2jCaseSensitivePattern(String patternString) {
        Pattern compiledPattern = re2jCaseSensitivePatternMap.get(patternString);
        if (compiledPattern == null) {
            compiledPattern = Pattern.compile((String)patternString);
            re2jCaseSensitivePatternMap.put(patternString, compiledPattern);
        }
        return compiledPattern;
    }
}

