/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.classifier.custom;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedCategory;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedClassifier;

public class UDCategorySerDeser {
    private static final Logger LOGGER = LoggerFactory.getLogger(UDCategorySerDeser.class);
    private static final String BUNDLE_NAME = "org.talend.dataquality.semantic";
    private static UserDefinedClassifier udc;
    private static ObjectMapper mapper;

    public static UserDefinedClassifier getRegexClassifier() throws IOException {
        if (udc == null) {
            udc = UDCategorySerDeser.readJsonFile();
        }
        return udc;
    }

    static UserDefinedClassifier readJsonFile() throws IOException {
        try {
            InputStream inputStream = UDCategorySerDeser.class.getResourceAsStream("/regex/categorizer.json");
            return UDCategorySerDeser.readJsonFile(inputStream);
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            URL url = new URL("platform:/plugin/org.talend.dataquality.semantic/regex/categorizer.json");
            InputStream inputStream = url.openConnection().getInputStream();
            return UDCategorySerDeser.readJsonFile(inputStream);
        }
    }

    static UserDefinedClassifier readJsonFile(InputStream inputStream) throws IOException {
        try {
            return (UserDefinedClassifier)mapper.readValue(inputStream, UserDefinedClassifier.class);
        }
        catch (JsonProcessingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    static UserDefinedClassifier readJsonFile(String content) throws IOException {
        try {
            return (UserDefinedClassifier)mapper.readValue(content, UserDefinedClassifier.class);
        }
        catch (JsonProcessingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    /*
     * Loose catch block
     */
    public static UserDefinedClassifier readJsonFile(URI uri) throws IOException {
        Throwable throwable = null;
        try (InputStream ins = uri.toURL().openStream();){
            String content = IOUtils.toString((InputStream)ins, (String)StandardCharsets.UTF_8.name());
            try {
                List list = (List)mapper.readValue(content, (TypeReference)new TypeReference<List<UserDefinedCategory>>(){});
                JsonNode arrayNode = mapper.valueToTree((Object)list);
                ObjectNode objNode = mapper.createObjectNode();
                objNode.set("classifiers", arrayNode);
                UserDefinedClassifier userDefinedClassifier = UDCategorySerDeser.readJsonFile(objNode.toString());
                return userDefinedClassifier;
            }
            catch (Exception e) {
                UserDefinedClassifier userDefinedClassifier;
                block17: {
                    block18: {
                        LOGGER.trace(e.getMessage(), (Throwable)e);
                        userDefinedClassifier = UDCategorySerDeser.readJsonFile(content);
                        if (ins == null) break block17;
                        if (throwable == null) break block18;
                        try {
                            ins.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block17;
                    }
                    ins.close();
                }
                return userDefinedClassifier;
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
            }
        }
    }

    public boolean writeToJsonFile(UserDefinedClassifier userDefinedClassifier, OutputStream outputStream) {
        try {
            mapper.writerWithDefaultPrettyPrinter().writeValue(outputStream, (Object)userDefinedClassifier);
            outputStream.close();
        }
        catch (Exception exc) {
            LOGGER.error(exc.getMessage(), (Throwable)exc);
            return false;
        }
        return true;
    }

    static {
        mapper = new ObjectMapper();
    }
}

