/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.classifier.custom;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.talend.dataquality.semantic.classifier.ISubCategory;
import org.talend.dataquality.semantic.classifier.SemanticCategoryEnum;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedRegexValidator;
import org.talend.dataquality.semantic.filter.ISemanticFilter;
import org.talend.dataquality.semantic.filter.impl.CharSequenceFilter;
import org.talend.dataquality.semantic.model.MainCategory;

public class UserDefinedCategory
implements ISubCategory {
    private static final long serialVersionUID = 8905048019099749771L;
    private String id;
    private String name;
    private String label;
    private String description;
    private MainCategory mainCategory;
    private ISemanticFilter filter;
    private UserDefinedRegexValidator validator;

    @JsonCreator
    public UserDefinedCategory(@JsonProperty(value="name") String name, @JsonProperty(value="label") String label) {
        if (name == null) {
            throw new IllegalArgumentException("A category has no name. Give a name, any name.");
        }
        this.name = name;
        this.label = label;
    }

    public UserDefinedCategory(String name) {
        this(name, name);
    }

    public UserDefinedCategory(String name, SemanticCategoryEnum cat) {
        if (name == null) {
            throw new IllegalArgumentException("A category has no name. Give a name, any name.");
        }
        this.name = name;
        this.label = cat == null ? name : cat.getDisplayName();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public ISemanticFilter getFilter() {
        return this.filter;
    }

    public void setFilter(CharSequenceFilter filter) {
        this.filter = filter;
    }

    @Override
    public UserDefinedRegexValidator getValidator() {
        return this.validator;
    }

    public void setValidator(UserDefinedRegexValidator validator) {
        this.validator = validator;
    }

    public MainCategory getMainCategory() {
        return this.mainCategory;
    }

    public void setMainCategory(MainCategory mainCategory) {
        this.mainCategory = mainCategory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserDefinedCategory that = (UserDefinedCategory)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return this.getLabel();
    }
}

