/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.classifier.custom;

import com.google.re2j.Pattern;
import com.google.re2j.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataquality.semantic.classifier.custom.CompiledRegexPatternCache;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedRegexValidator;
import org.talend.dataquality.semantic.exception.DQSemanticRuntimeException;

public class UserDefinedRE2JRegexValidator
extends UserDefinedRegexValidator {
    private static final long serialVersionUID = -7087456754020469957L;
    private static final Logger LOGGER = LoggerFactory.getLogger(UserDefinedRE2JRegexValidator.class);
    private Pattern caseSensitiveRe2JPattern;
    private Pattern caseInsensitiveRe2JPattern;

    @Override
    public void setPatternString(String patternString) {
        if (StringUtils.isEmpty((CharSequence)patternString)) {
            throw new DQSemanticRuntimeException("null argument of patternString is not allowed.");
        }
        this.patternString = patternString;
        try {
            this.caseInsensitiveRe2JPattern = CompiledRegexPatternCache.getRe2jCaseInsensitivePattern(patternString);
            this.caseSensitiveRe2JPattern = CompiledRegexPatternCache.getRe2jCaseSensitivePattern(patternString);
        }
        catch (PatternSyntaxException | IllegalArgumentException e) {
            LOGGER.info("Invalid regular expression: {}", (Object)this.patternString);
            LOGGER.debug("Exception thrown: ", e);
        }
    }

    @Override
    public boolean isValid(String str, boolean caseSensitive) {
        if (!this.checkValid(str, caseSensitive)) {
            return false;
        }
        return !this.isSetSubValidator || this.validateWithSubValidator(str);
    }

    private boolean checkValid(String str, boolean caseSensitive) {
        if (str == null || this.caseSensitiveRe2JPattern == null || this.caseInsensitiveRe2JPattern == null) {
            return false;
        }
        return caseSensitive ? this.caseSensitiveRe2JPattern.matcher((CharSequence)str.trim()).find() : this.caseInsensitiveRe2JPattern.matcher((CharSequence)str.trim()).find();
    }
}

