/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.classifier.impl;

import java.util.HashSet;
import java.util.Set;
import org.talend.dataquality.semantic.classifier.ISubCategory;
import org.talend.dataquality.semantic.classifier.ISubCategoryClassifier;
import org.talend.dataquality.semantic.filter.ISemanticFilter;
import org.talend.dataquality.semantic.validator.ISemanticValidator;

public abstract class AbstractSubCategoryClassifier
implements ISubCategoryClassifier {
    private static final long serialVersionUID = -5396224246178196818L;
    protected Set<ISubCategory> potentialSubCategories = new HashSet<ISubCategory>();

    @Override
    public Set<String> classify(String data) {
        HashSet<String> catSet = new HashSet<String>();
        for (ISubCategory classifier : this.potentialSubCategories) {
            ISemanticValidator validator;
            ISemanticFilter filter = classifier.getFilter();
            if (filter != null && !filter.isQualified(data) || (validator = classifier.getValidator()) == null || !validator.isValid(data)) continue;
            catSet.add(classifier.getName());
        }
        return catSet;
    }

    public Set<ISubCategory> getClassifiers() {
        return this.potentialSubCategories;
    }

    public void setClassifiers(Set<ISubCategory> classifiers) {
        this.potentialSubCategories = classifiers;
    }
}

