/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.datamasking;

import com.mifmif.common.regex.Generex;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.apache.commons.math3.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataquality.datamasking.functions.Function;
import org.talend.dataquality.datamasking.functions.FunctionString;
import org.talend.dataquality.datamasking.semantic.ReplaceCharactersWithGeneration;
import org.talend.dataquality.semantic.Distribution;
import org.talend.dataquality.semantic.datamasking.FunctionBuilder;
import org.talend.dataquality.semantic.datamasking.MaskableCategoryEnum;
import org.talend.dataquality.semantic.datamasking.model.CategoryValues;
import org.talend.dataquality.semantic.model.CategoryType;
import org.talend.dataquality.semantic.snapshot.DictionarySnapshot;
import org.talend.dataquality.semantic.statistics.SemanticQualityAnalyzer;
import org.talend.dataquality.semantic.utils.RegexUtils;

public class GenerateFromCompound
extends FunctionString {
    private static final long serialVersionUID = -2098232246954624570L;
    private static final Logger LOGGER = LoggerFactory.getLogger(GenerateFromCompound.class);
    private List<CategoryValues> categoryValues = null;
    private DictionarySnapshot dictionarySnapshot = null;
    private SemanticQualityAnalyzer analyzer = null;

    protected String doGenerateMaskedFieldWithRandom(String str, Random r) {
        Optional<List<CategoryValues>> catValues;
        String result = "";
        if (this.analyzer == null) {
            this.analyzer = new SemanticQualityAnalyzer(this.dictionarySnapshot, Arrays.toString(this.categoryValues.stream().map(CategoryValues::getName).toArray()));
        }
        if ((catValues = this.findMatchTypes(str)).isPresent()) {
            Distribution<String> distribution = this.processDistribution(catValues.get(), r);
            try {
                result = this.getMaskedValue(str, distribution, r);
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOGGER.info(e.getMessage(), (Throwable)e);
            }
        } else {
            ReplaceCharactersWithGeneration function = new ReplaceCharactersWithGeneration();
            function.parse("X", true);
            function.setSeed(this.seed);
            function.setMaskingMode(this.maskingMode);
            result = (String)((Object)function.generateMaskedRow((Serializable)((Object)str)));
        }
        return result;
    }

    private Optional<List<CategoryValues>> findMatchTypes(String value) {
        ArrayList<CategoryValues> categoryValuesResult = new ArrayList<CategoryValues>();
        Optional<List<CategoryValues>> result = Optional.empty();
        for (CategoryValues category : this.categoryValues) {
            if (!this.analyzer.isValid(this.dictionarySnapshot.getDQCategoryByName(category.getName()), value)) continue;
            categoryValuesResult.add(category);
        }
        if (!categoryValuesResult.isEmpty()) {
            result = Optional.of(categoryValuesResult);
        }
        return result;
    }

    public void parse(String semanticCategoryId, boolean keepNullValues) {
        this.setKeepNull(keepNullValues);
    }

    private Distribution<String> processDistribution(List<CategoryValues> categories, Random r) {
        int nbElem;
        int largestDict;
        ArrayList<List> values = new ArrayList<List>();
        for (CategoryValues category : categories) {
            if (!CategoryType.DICT.equals((Object)category.getType())) continue;
            values.add((List)category.getValue());
        }
        long nbRegex = categories.stream().filter(cat -> CategoryType.REGEX.equals((Object)cat.getType())).count();
        if (!values.isEmpty()) {
            largestDict = values.stream().max(Comparator.comparing(List::size)).orElse(Collections.emptyList()).size();
            nbElem = (int)((long)values.stream().mapToInt(List::size).sum() + nbRegex * (long)largestDict);
        } else {
            largestDict = 1;
            nbElem = (int)nbRegex;
        }
        ArrayList probabilities = new ArrayList();
        categories.forEach(categValues -> {
            if (CategoryType.DICT.equals((Object)categValues.getType())) {
                probabilities.add(new Pair((Object)categValues.getCategoryId(), (Object)((double)((List)categValues.getValue()).size() / (double)nbElem)));
            } else if (CategoryType.REGEX.equals((Object)categValues.getType())) {
                probabilities.add(new Pair((Object)categValues.getCategoryId(), (Object)((double)largestDict / (double)nbElem)));
            }
        });
        return new Distribution<String>(probabilities, r);
    }

    private String getMaskedValue(String value, Distribution<String> distribution, Random r) throws IllegalAccessException, InstantiationException {
        String result = "";
        String key = distribution.sample();
        Optional<CategoryValues> cats = this.categoryValues.stream().filter(cat -> key.equals(cat.getCategoryId())).findAny();
        if (cats.isPresent()) {
            CategoryValues catValues = cats.get();
            MaskableCategoryEnum cat2 = MaskableCategoryEnum.getCategoryById(catValues.getName());
            if (cat2 != null) {
                Function<String> function = FunctionBuilder.functionInitializer(cat2);
                function.setSeed(this.seed);
                function.setMaskingMode(this.maskingMode);
                result = (String)((Object)function.generateMaskedRow((Serializable)((Object)value)));
            } else {
                CategoryType type = catValues.getType();
                if (CategoryType.DICT.equals((Object)type)) {
                    List values = (List)catValues.getValue();
                    result = (String)values.get(r.nextInt(values.size()));
                } else if (CategoryType.REGEX.equals((Object)type)) {
                    String regex = RegexUtils.removeStartingAndEndingAnchors((String)catValues.getValue());
                    Generex generex = new Generex(regex, r);
                    result = generex.random();
                }
            }
        }
        return result;
    }

    public void setCategoryValues(List<CategoryValues> categoryValues) {
        this.categoryValues = categoryValues;
        if (this.dictionarySnapshot != null) {
            this.analyzer = new SemanticQualityAnalyzer(this.dictionarySnapshot, Arrays.toString(categoryValues.stream().map(CategoryValues::getName).toArray()));
        }
    }

    public void setDictionarySnapshot(DictionarySnapshot dictionarySnapshot) {
        this.dictionarySnapshot = dictionarySnapshot;
    }
}

