/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.datamasking;

import com.mifmif.common.regex.Generex;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.talend.dataquality.datamasking.FunctionMode;
import org.talend.dataquality.datamasking.functions.FunctionString;
import org.talend.dataquality.semantic.utils.RegexUtils;

public class GenerateFromRegex
extends FunctionString {
    private static final long serialVersionUID = 2315410175790920472L;
    protected transient Generex generex = null;
    private transient String patternStr;
    private static final String[] invalidKw = new String[]{"(?:", "(?!", "(?=", "[[:space:]]", "[[:digit:]]", "\\u"};

    protected String doGenerateMaskedFieldWithRandom(String str, Random r) {
        if (this.keepNull && str == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        if (FunctionMode.CONSISTENT == this.maskingMode) {
            Generex gen = new Generex(this.patternStr, r);
            return gen.random();
        }
        return this.generex.random();
    }

    public void parse(String extraParameter, boolean keepNullValues) {
        if (extraParameter != null) {
            this.patternStr = RegexUtils.removeStartingAndEndingAnchors(extraParameter);
            this.generex = new Generex(this.patternStr);
            this.setKeepNull(keepNullValues);
        }
    }

    public void setRandom(Random rand) {
        super.setRandom(rand);
        if (this.generex != null) {
            this.generex.setSeed(this.rnd.nextLong());
        }
    }

    public static boolean isValidPattern(String patternString) {
        if (patternString == null) {
            return false;
        }
        for (String keyWord : invalidKw) {
            if (!patternString.contains(keyWord)) continue;
            return false;
        }
        return Generex.isValidPattern((String)patternString);
    }
}

