/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.datamasking;

import java.security.SecureRandom;
import java.util.List;
import java.util.Random;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataquality.datamasking.FunctionFactory;
import org.talend.dataquality.datamasking.FunctionMode;
import org.talend.dataquality.datamasking.FunctionType;
import org.talend.dataquality.datamasking.TypeTester;
import org.talend.dataquality.datamasking.exception.DQMaskingException;
import org.talend.dataquality.datamasking.functions.Function;
import org.talend.dataquality.datamasking.functions.date.DateVariance;
import org.talend.dataquality.datamasking.functions.text.replace.ReplaceAll;
import org.talend.dataquality.datamasking.semantic.AbstractDateFunction;
import org.talend.dataquality.datamasking.semantic.DateFunctionAdapter;
import org.talend.dataquality.datamasking.semantic.FluctuateNumericString;
import org.talend.dataquality.datamasking.semantic.ReplaceCharactersWithGeneration;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedClassifier;
import org.talend.dataquality.semantic.datamasking.FunctionBuilder;
import org.talend.dataquality.semantic.datamasking.GenerateFromCompound;
import org.talend.dataquality.semantic.datamasking.GenerateFromDictionaries;
import org.talend.dataquality.semantic.datamasking.GenerateFromRegex;
import org.talend.dataquality.semantic.datamasking.MaskableCategoryEnum;
import org.talend.dataquality.semantic.datamasking.model.CategoryValues;
import org.talend.dataquality.semantic.model.CategoryType;
import org.talend.dataquality.semantic.model.DQCategory;
import org.talend.dataquality.semantic.snapshot.DictionarySnapshot;
import org.talend.dataquality.semantic.validator.GenerateValidator;

public class SemanticMaskerFunctionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SemanticMaskerFunctionFactory.class);

    private SemanticMaskerFunctionFactory() {
    }

    public static Function<String> createMaskerFunctionForSemanticCategory(String semanticCategory, String dataType, @NotNull DictionarySnapshot dictionarySnapshot) {
        return SemanticMaskerFunctionFactory.createMaskerFunctionForSemanticCategory(semanticCategory, dataType, null, dictionarySnapshot, null, FunctionMode.RANDOM);
    }

    public static Function<String> createMaskerFunctionForSemanticCategory(String semanticCategory, String dataType, List<String> params, @NotNull DictionarySnapshot dictionarySnapshot) {
        return SemanticMaskerFunctionFactory.createMaskerFunctionForSemanticCategory(semanticCategory, dataType, params, dictionarySnapshot, null, FunctionMode.RANDOM);
    }

    public static Function<String> createMaskerFunctionForSemanticCategory(String semanticCategory, String dataType, List<String> params, @NotNull DictionarySnapshot dictionarySnapshot, String seed, FunctionMode mode) {
        DQCategory category;
        Object function = null;
        MaskableCategoryEnum cat = MaskableCategoryEnum.getCategoryById(semanticCategory);
        if (cat != null) {
            try {
                function = FunctionBuilder.functionInitializer(cat);
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
        if (function == null && (category = dictionarySnapshot.getDQCategoryByName(semanticCategory)) != null) {
            CategoryType categoryType = category.getType();
            String extraParameter = category.getId();
            switch (categoryType) {
                case DICT: {
                    function = new GenerateFromDictionaries();
                    ((GenerateFromDictionaries)((Object)function)).setDictionarySnapshot(dictionarySnapshot);
                    break;
                }
                case REGEX: {
                    UserDefinedClassifier udc = dictionarySnapshot.getRegexClassifier();
                    String patternString = udc.getPatternStringByCategoryId(category.getId());
                    boolean isGenerexCompliant = udc.isGenerexCompliant(category.getId());
                    if (!GenerateFromRegex.isValidPattern(patternString) || !isGenerexCompliant) break;
                    function = new GenerateFromRegex();
                    extraParameter = patternString;
                    break;
                }
                case COMPOUND: {
                    List<CategoryValues> types = GenerateValidator.initSemanticTypes(dictionarySnapshot, category);
                    if (types.isEmpty()) break;
                    function = new GenerateFromCompound();
                    ((GenerateFromCompound)((Object)function)).setDictionarySnapshot(dictionarySnapshot);
                    ((GenerateFromCompound)((Object)function)).setCategoryValues(types);
                    break;
                }
            }
            if (function != null) {
                function.parse(extraParameter, true);
            }
        }
        if (function == null) {
            switch (dataType) {
                case "numeric": 
                case "integer": 
                case "float": 
                case "double": 
                case "decimal": {
                    function = new FluctuateNumericString();
                    function.parse("10", true);
                    break;
                }
                case "date": {
                    DateVariance df = new DateVariance();
                    df.parse("61", true);
                    function = new DateFunctionAdapter((AbstractDateFunction)df, params);
                    break;
                }
                case "string": {
                    function = new ReplaceCharactersWithGeneration();
                    function.parse("X", true);
                    break;
                }
            }
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("No masking function available for the current column! SemanticCategory: %s DataType: %s", semanticCategory, dataType));
        }
        function.setMaskingMode(mode);
        if (StringUtils.isNotEmpty((CharSequence)seed)) {
            function.setSeed(seed);
        } else {
            function.setRandom((Random)new SecureRandom());
        }
        return function;
    }

    private static Function<String> adaptForDateFunction(List<String> datePatterns, AbstractDateFunction functionToAdapt, String extraParam) {
        functionToAdapt.parse(extraParam, true);
        return new DateFunctionAdapter(functionToAdapt, datePatterns);
    }

    public static Function<String> getMaskerFunctionByFunctionName(FunctionType functionType, String dataType, String extraParam) {
        Object function;
        FunctionFactory factory = new FunctionFactory();
        TypeTester tester = new TypeTester();
        try {
            function = FunctionType.KEEP_YEAR.equals((Object)functionType) || FunctionType.DATE_VARIANCE.equals((Object)functionType) ? SemanticMaskerFunctionFactory.adaptForDateFunction(null, (AbstractDateFunction)factory.getFunction(functionType, tester.getTypeByName(dataType)), extraParam) : (FunctionType.NUMERIC_VARIANCE.equals((Object)functionType) ? new FluctuateNumericString() : (FunctionType.REPLACE_ALL.equals((Object)functionType) ? new ReplaceAll() : factory.getFunction(functionType, tester.getTypeByName(dataType))));
            function.parse(extraParam, true);
            function.setKeepFormat(true);
            function.setKeepEmpty(true);
        }
        catch (DQMaskingException e) {
            LOGGER.debug("Exception thrown : ", (Throwable)e);
            throw new IllegalArgumentException(String.format("No masking function available for the current column!  %s DataType: ", dataType));
        }
        return function;
    }

    public static Function<String> getMaskerFunctionByFunctionName(FunctionType functionType, String dataType, String extraParam, String seed, FunctionMode mode) {
        Function<String> function = SemanticMaskerFunctionFactory.getMaskerFunctionByFunctionName(functionType, dataType, extraParam);
        function.setSeed(seed);
        function.setMaskingMode(mode);
        return function;
    }
}

