/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.extraction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataquality.semantic.extraction.ExtractFromSemanticType;
import org.talend.dataquality.semantic.extraction.MatchedPart;
import org.talend.dataquality.semantic.extraction.TokenizedString;

public class FieldExtractionFunction {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldExtractionFunction.class);
    private List<ExtractFromSemanticType> functions;

    protected FieldExtractionFunction(List<ExtractFromSemanticType> functions) {
        this.functions = functions;
    }

    public Map<String, List<String>> extractFieldParts(String field) {
        if (this.isEmpty(field)) {
            return new HashMap<String, List<String>>();
        }
        ArrayList<MatchedPart> matches = new ArrayList<MatchedPart>();
        HashMap<String, List<String>> matchesByCategory = new HashMap<String, List<String>>();
        for (int i = 0; i < this.functions.size(); ++i) {
            ExtractFromSemanticType function = this.functions.get(i);
            try {
                List<MatchedPart> functionMatches = function.getMatches(field);
                ArrayList<String> matchString = new ArrayList<String>();
                for (MatchedPart match : functionMatches) {
                    match.setPriority(i);
                    matchString.add(match.getExactMatch());
                }
                matchesByCategory.put(function.getCategoryName(), matchString);
                matches.addAll(functionMatches);
                continue;
            }
            catch (IllegalArgumentException exception) {
                LOGGER.info(exception.getMessage(), (Throwable)exception);
            }
        }
        this.filterOverlappingMatches(matches, matchesByCategory);
        return matchesByCategory;
    }

    private boolean isEmpty(String field) {
        return field == null || new TokenizedString(field).getTokens().isEmpty();
    }

    private void filterOverlappingMatches(List<MatchedPart> matches, Map<String, List<String>> matchesByCategory) {
        Collections.sort(matches);
        HashSet<Integer> matchedTokens = new HashSet<Integer>();
        for (MatchedPart match : matches) {
            boolean toAdd = true;
            for (Integer token : match.getTokenPositions()) {
                if (!matchedTokens.contains(token)) continue;
                ExtractFromSemanticType function = this.functions.get(match.getPriority());
                matchesByCategory.get(function.getCategoryName()).remove(match.getExactMatch());
                toAdd = false;
                break;
            }
            if (!toAdd) continue;
            matchedTokens.addAll(match.getTokenPositions());
        }
    }
}

