/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.extraction;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.talend.dataquality.semantic.extraction.TokenizedString;

public abstract class MatchedPart
implements Comparable<MatchedPart> {
    protected TokenizedString originalField;
    protected int start;
    protected int end;
    @Deprecated
    protected String exactMatch;
    protected List<Integer> tokenPositions;
    private int priority;

    protected MatchedPart() {
    }

    protected abstract void checkBounds(int var1, int var2);

    protected void initTokenPositions() {
        this.tokenPositions = new ArrayList<Integer>(this.end - this.start + 1);
        for (int i = this.start; i <= this.end; ++i) {
            this.tokenPositions.add(i);
        }
    }

    public String getExactMatch() {
        return this.exactMatch;
    }

    private int getNumberOfTokens() {
        return this.tokenPositions.size();
    }

    public List<Integer> getTokenPositions() {
        return this.tokenPositions;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int compareTo(MatchedPart o) {
        int compared = Integer.compare(o.getNumberOfTokens(), this.getNumberOfTokens());
        return compared == 0 ? Integer.compare(this.priority, o.priority) : compared;
    }

    public int hashCode() {
        return Objects.hash(this.exactMatch);
    }

    public String toString() {
        return "Original Field:" + this.originalField.getValue() + ", Exact Match:" + this.getExactMatch() + ", Start Token:" + this.start + ", End Token:" + this.end + ", Priority:" + this.priority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MatchedPart)) {
            return false;
        }
        MatchedPart otherMatchedPart = (MatchedPart)o;
        return this.originalField.equals(otherMatchedPart.originalField) && this.exactMatch.equals(otherMatchedPart.exactMatch);
    }
}

