/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.extraction;

import org.talend.dataquality.semantic.extraction.MatchedPart;
import org.talend.dataquality.semantic.extraction.TokenizedString;

public class MatchedPartRegex
extends MatchedPart {
    public MatchedPartRegex(TokenizedString tokenizedField, int startChar, int endChar) {
        this.originalField = tokenizedField;
        this.checkBounds(startChar, endChar);
        String field = tokenizedField.getValue();
        this.exactMatch = field.substring(startChar, endChar);
        this.start = this.getTokenNumber(field.substring(0, startChar));
        this.end = this.getTokenNumber(field.substring(0, endChar)) - 1;
        this.initTokenPositions();
    }

    @Override
    protected void checkBounds(int start, int end) {
        if (start < 0 || end < 0 || end < start || end > this.originalField.getValue().length()) {
            throw new IllegalArgumentException("Bounds for match are incorrect : start = {}, end = {}" + start + end);
        }
    }

    private int getTokenNumber(String string) {
        TokenizedString tokenizedString = new TokenizedString(string);
        return tokenizedString.getTokens().size();
    }
}

