/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.extraction;

import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.talend.dataquality.semantic.extraction.ExtractFromCompound;
import org.talend.dataquality.semantic.extraction.ExtractFromDictionary;
import org.talend.dataquality.semantic.extraction.ExtractFromRegex;
import org.talend.dataquality.semantic.extraction.ExtractFromSemanticType;
import org.talend.dataquality.semantic.extraction.FieldExtractionFunction;
import org.talend.dataquality.semantic.model.DQCategory;
import org.talend.dataquality.semantic.snapshot.DictionarySnapshot;

public class SemanticExtractionFunctionFactory {
    private SemanticExtractionFunctionFactory() {
    }

    @Deprecated
    public static FieldExtractionFunction createFieldExtractionFunction(List<String> categoryList, @NotNull DictionarySnapshot dictionarySnapshot) {
        return SemanticExtractionFunctionFactory.createFieldExtractionFunction(categoryList, dictionarySnapshot, false);
    }

    public static FieldExtractionFunction createFieldExtractionFunction(List<String> categoryList, @NotNull DictionarySnapshot dictionarySnapshot, boolean standardize) {
        ArrayList<ExtractFromSemanticType> extractFunctions = new ArrayList<ExtractFromSemanticType>();
        for (String semanticCategory : categoryList) {
            DQCategory category = dictionarySnapshot.getDQCategoryByName(semanticCategory);
            if (category == null) {
                throw new IllegalArgumentException("Invalid Semantic Category Name : " + semanticCategory);
            }
            ExtractFromSemanticType function = SemanticExtractionFunctionFactory.getFunction(category, dictionarySnapshot, standardize);
            if (function == null) continue;
            extractFunctions.add(function);
        }
        return new FieldExtractionFunction(extractFunctions);
    }

    protected static ExtractFromSemanticType getFunction(DQCategory category, DictionarySnapshot dicoSnapshot, boolean standardize) {
        ExtractFromSemanticType function = null;
        switch (category.getType()) {
            case DICT: {
                function = new ExtractFromDictionary(dicoSnapshot, category, standardize);
                break;
            }
            case REGEX: {
                function = new ExtractFromRegex(dicoSnapshot, category);
                break;
            }
            case COMPOUND: {
                function = new ExtractFromCompound(dicoSnapshot, category, standardize);
                break;
            }
        }
        return function;
    }
}

