/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.extraction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Deprecated
public class TokenizedString {
    public static final String DEFAULT_SEPARATORS = "[[\\p{Punct}&&[^'.]]\\s\\u00A0\\u2007\\u202F\\u3000]+";
    public static final String FULL_SEPARATORS = "[\\p{Punct}\\s\\u00A0\\u2007\\u202F\\u3000]+";
    private Pattern separatorPattern = Pattern.compile("[[\\p{Punct}&&[^'.]]\\s\\u00A0\\u2007\\u202F\\u3000]+");
    private final String value;
    private final List<String> tokens;
    private final List<String> separators;
    private boolean startingWithSeparator;
    private boolean endingWithSeparator;

    public TokenizedString(String str, String listOfSeparators) {
        this.value = str;
        this.separatorPattern = Pattern.compile(listOfSeparators);
        this.tokens = TokenizedString.tokenize(this.value, listOfSeparators);
        this.separators = new ArrayList<String>(this.tokens.size());
        this.extractSeparators();
    }

    public TokenizedString(String str) {
        this.value = str;
        this.tokens = TokenizedString.tokenize(this.value);
        this.separators = new ArrayList<String>(this.tokens.size());
        this.extractSeparators();
    }

    public boolean isStartingWithSeparator() {
        return this.startingWithSeparator;
    }

    public boolean isEndingWithSeparator() {
        return this.endingWithSeparator;
    }

    public List<String> getTokens() {
        return this.tokens;
    }

    public List<String> getSeparators() {
        return this.separators;
    }

    public static List<String> tokenize(String field) {
        return TokenizedString.tokenize(field, DEFAULT_SEPARATORS);
    }

    public static List<String> tokenize(String field, String separators) {
        Pattern separatorPattern = Pattern.compile(separators);
        ArrayList<String> fieldTokens = new ArrayList<String>(Arrays.asList(separatorPattern.split(field)));
        if (!fieldTokens.isEmpty() && ((String)fieldTokens.get(0)).isEmpty()) {
            fieldTokens.remove(0);
        }
        return fieldTokens;
    }

    public Pattern getSeparatorPattern() {
        return this.separatorPattern;
    }

    public String getValue() {
        return this.value;
    }

    public TokenizedString getMatchingSubPart(TokenizedString tokenizedMatch, int startToken, int endToken) {
        int startSeparator;
        boolean startWithSeparator = tokenizedMatch.isStartingWithSeparator();
        boolean endWithSeparator = tokenizedMatch.isEndingWithSeparator();
        List<String> matchSeparators = tokenizedMatch.separators;
        this.checkMatchCompatibility(startToken, endToken, startWithSeparator, endWithSeparator);
        StringBuilder joinedValue = new StringBuilder();
        int n = startSeparator = this.startingWithSeparator ? startToken : startToken - 1;
        if (startWithSeparator) {
            joinedValue.append(this.getCommonStartingSeparator(this.separators.get(startSeparator), matchSeparators.get(0)));
        }
        int curSeparator = startSeparator + 1;
        for (int i = startToken; i < endToken; ++i) {
            joinedValue.append(this.tokens.get(i)).append(this.separators.get(curSeparator++));
        }
        joinedValue.append(this.tokens.get(endToken));
        if (endWithSeparator) {
            joinedValue.append(this.getCommonEndingSeparator(this.separators.get(curSeparator), matchSeparators.get(matchSeparators.size() - 1)));
        }
        return new TokenizedString(joinedValue.toString(), this.separatorPattern.pattern());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenizedString that = (TokenizedString)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    private void extractSeparators() {
        Matcher matcher = this.separatorPattern.matcher(this.value);
        this.startingWithSeparator = false;
        this.endingWithSeparator = false;
        while (matcher.find()) {
            if (matcher.start() == 0) {
                this.startingWithSeparator = true;
            } else if (matcher.end() == this.value.length()) {
                this.endingWithSeparator = true;
            }
            this.separators.add(matcher.group());
        }
    }

    private void checkMatchCompatibility(int startToken, int endToken, boolean startWithSeparator, boolean endWithSeparator) {
        if (startToken == 0 && startWithSeparator && !this.startingWithSeparator) {
            throw new IllegalArgumentException("Can't find starting separator for this field subpart.");
        }
        if (endToken == this.tokens.size() - 1 && endWithSeparator && !this.endingWithSeparator) {
            throw new IllegalArgumentException("Can't find ending separator for this field subpart.");
        }
        int neededSeparators = endToken - startToken + (startWithSeparator ? 1 : 0) + (endWithSeparator ? 1 : 0);
        if (this.separators.size() < neededSeparators) {
            throw new IllegalArgumentException("Not enough separators in tokenized string to build this field subpart.");
        }
    }

    private String getCommonEndingSeparator(String endingSeparator, String matchEndingSeparator) {
        String endStartingSeparator;
        String commonEndingSeparator = "";
        if (endingSeparator.equals(matchEndingSeparator)) {
            commonEndingSeparator = endingSeparator;
        } else if (endingSeparator.length() > matchEndingSeparator.length() && (endStartingSeparator = endingSeparator.substring(0, matchEndingSeparator.length())).equals(matchEndingSeparator)) {
            commonEndingSeparator = endStartingSeparator;
        }
        return commonEndingSeparator;
    }

    private String getCommonStartingSeparator(String startingSeparator, String matchStartingSeparator) {
        String endStartingSeparator;
        String commonStartingSeparator = "";
        if (startingSeparator.equals(matchStartingSeparator)) {
            commonStartingSeparator = startingSeparator;
        } else if (startingSeparator.length() > matchStartingSeparator.length() && (endStartingSeparator = startingSeparator.substring(startingSeparator.length() - matchStartingSeparator.length())).equals(matchStartingSeparator)) {
            commonStartingSeparator = endStartingSeparator;
        }
        return commonStartingSeparator;
    }
}

