/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.filter.impl;

import org.talend.dataquality.semantic.filter.ISemanticFilter;

public class CharSequenceFilter
implements ISemanticFilter {
    private static final long serialVersionUID = 721733127885462464L;
    private CharSequenceFilterType filterType;
    private String filterParam;

    public CharSequenceFilter() {
    }

    public CharSequenceFilter(CharSequenceFilterType type, String param) {
        this.filterType = type;
        this.filterParam = param;
    }

    @Override
    public boolean isQualified(String str) {
        switch (this.filterType) {
            case MUST_CONTAIN: {
                return str.contains(this.filterParam);
            }
            case MUST_NOT_CONTAIN: {
                return !str.contains(this.filterParam);
            }
            case MUST_START_WITH: {
                return str.startsWith(this.filterParam);
            }
            case MUST_END_WITH: {
                return str.endsWith(this.filterParam);
            }
        }
        return true;
    }

    public CharSequenceFilterType getFilterType() {
        return this.filterType;
    }

    public void setFilterType(CharSequenceFilterType filterType) {
        this.filterType = filterType;
    }

    public String getFilterParam() {
        return this.filterParam;
    }

    public void setFilterParam(String filterParam) {
        this.filterParam = filterParam;
    }

    public static enum CharSequenceFilterType {
        MUST_CONTAIN,
        MUST_NOT_CONTAIN,
        MUST_START_WITH,
        MUST_END_WITH;

    }
}

