/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.index;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.RoaringDocIdSet;

public class CachingFilterQuery
extends Query
implements Cloneable {
    private Query query;
    private final Map<Object, DocIdSet> cache = Collections.synchronizedMap(new WeakHashMap());

    public CachingFilterQuery(Query query) {
        this.query = Objects.requireNonNull(query, "Query must not be null");
    }

    public Query getQuery() {
        return this.query;
    }

    protected DocIdSet cacheImpl(DocIdSetIterator iterator, LeafReader reader) throws IOException {
        return new RoaringDocIdSet.Builder(reader.maxDoc()).add(iterator).build();
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = this.query.rewrite(reader);
        if (this.query == rewritten) {
            return super.rewrite(reader);
        }
        CachingFilterQuery clone = this.clone();
        clone.query = rewritten;
        return clone;
    }

    public CachingFilterQuery clone() {
        return new CachingFilterQuery(this.query);
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        final Weight weight = this.query.createWeight(searcher, ScoreMode.COMPLETE_NO_SCORES, 0.0f);
        return new ConstantScoreWeight(weight.getQuery(), 0.0f){

            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }

            public Scorer scorer(LeafReaderContext context) throws IOException {
                DocIdSet docIdSet = this.getDocIdSet(context);
                assert (docIdSet != null);
                if (docIdSet == DocIdSet.EMPTY) {
                    return null;
                }
                DocIdSetIterator docIdSetIterator = docIdSet.iterator();
                if (docIdSetIterator == null) {
                    return null;
                }
                return new ConstantScoreScorer((Weight)this, 0.0f, ScoreMode.COMPLETE_NO_SCORES, docIdSetIterator);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private DocIdSet getDocIdSet(LeafReaderContext context) throws IOException {
                LeafReader reader = context.reader();
                IndexReader.CacheKey key = reader.getCoreCacheHelper().getKey();
                Object cached = CachingFilterQuery.this.cache.get(key);
                if (cached != null) {
                    return (DocIdSet)cached;
                }
                Map map = CachingFilterQuery.this.cache;
                synchronized (map) {
                    cached = CachingFilterQuery.this.cache.get(key);
                    if (cached != null) {
                        return (DocIdSet)cached;
                    }
                    Scorer scorer = weight.scorer(context);
                    DocIdSet docIdSet = scorer == null ? DocIdSet.EMPTY : CachingFilterQuery.this.cacheImpl(scorer.iterator(), reader);
                    CachingFilterQuery.this.cache.put(key, docIdSet);
                    return docIdSet;
                }
            }
        };
    }

    public String toString(String field) {
        return this.getClass().getSimpleName() + "(" + this.query.toString(field) + ")";
    }

    public boolean equals(Object o) {
        if (o instanceof CachingFilterQuery) {
            return false;
        }
        CachingFilterQuery other = (CachingFilterQuery)o;
        return this.query.equals((Object)other.query);
    }

    public int hashCode() {
        return this.query.hashCode();
    }
}

