/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.index;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataquality.semantic.api.SemanticProperties;
import org.talend.dataquality.semantic.exception.DQSemanticRuntimeException;
import org.talend.dataquality.semantic.index.JARDirectory;
import org.talend.dataquality.semantic.index.PlatformPathUtil;

public class ClassPathDirectory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassPathDirectory.class);
    private static final String OPENING = "Opening '{}' ...";
    private static JARDirectoryProvider provider = new SingletonProvider();

    private ClassPathDirectory() {
    }

    public static synchronized void setProvider(JARDirectoryProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Provider can not be null.");
        }
        ClassPathDirectory.provider = provider;
    }

    public static synchronized Directory open(URI uri, SemanticProperties semanticProperties) {
        if ("jar".equals(uri.getScheme())) {
            LOGGER.info(OPENING, (Object)uri);
            try {
                return provider.get(uri, semanticProperties);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to open JAR '" + uri + "'.", e);
            }
        }
        if ("bundleresource".equals(uri.getScheme())) {
            LOGGER.info(OPENING, (Object)uri);
            try {
                Bundle bundle = FrameworkUtil.getBundle(ClassPathDirectory.class);
                LOGGER.debug("Opened bundle {}, {}", (Object)bundle.getBundleId(), (Object)bundle.getLocation());
                List<URL> entries = ClassPathDirectory.safeToList(bundle.findEntries("/", "rule-repository-presigned*", true));
                entries.addAll(ClassPathDirectory.safeToList(bundle.findEntries("/", "dataquality-semantic*", true)));
                LOGGER.debug("Found entries: {}", entries);
                for (URL url : entries) {
                    String jarPath = ClassPathDirectory.getLocalJarPath(bundle, url.getFile());
                    if (jarPath == null) continue;
                    LOGGER.debug("Local jar path = {}", (Object)jarPath);
                    String sourceSubFolder = uri.getPath();
                    uri = new URL("jar:file://" + jarPath + "!" + sourceSubFolder).toURI();
                }
                return provider.get(uri, semanticProperties);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to open JAR '" + uri + "'.", e);
            }
        }
        return ClassPathDirectory.open(uri);
    }

    public static synchronized Directory open(URI uri) {
        if ("jar".equals(uri.getScheme())) {
            throw new DQSemanticRuntimeException("Use {@link #open(URI, SemanticProperties)} for jar");
        }
        if ("file".equals(uri.getScheme())) {
            LOGGER.info(OPENING, (Object)uri);
            try {
                return FSDirectory.open((Path)Paths.get(uri));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to open path '" + uri + "'.", e);
            }
        }
        if ("bundleresource".equals(uri.getScheme())) {
            LOGGER.info(OPENING, (Object)uri);
            try {
                String path = PlatformPathUtil.getFilePathByPlatformURL(uri.toURL());
                return FSDirectory.open((Path)Paths.get(path, new String[0]));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to open bundleresource '" + uri + "'.", e);
            }
        }
        LOGGER.info(OPENING, (Object)uri);
        throw new UnsupportedOperationException("Unsupported scheme '" + uri.getScheme() + "'.");
    }

    public static void destroy() {
        provider.destroy();
    }

    private static List<URL> safeToList(Enumeration<URL> entries) {
        if (entries == null) {
            return Collections.emptyList();
        }
        return Collections.list(entries);
    }

    private static String getLocalJarPath(Bundle bundle, String jarName) {
        LOGGER.debug("Found jar {}", (Object)jarName);
        File f = bundle.getDataFile(jarName);
        if (f == null) {
            return null;
        }
        LOGGER.debug("Got file {}", (Object)f.getAbsolutePath());
        String dataPath = f.toPath().getParent().getParent().getParent().toString();
        String jarPath = (dataPath + "/0/.cp" + jarName).replaceAll("\\\\", "/");
        if (!jarPath.startsWith("/")) {
            jarPath = "/" + jarPath;
        }
        return jarPath;
    }

    public static class BasicProvider
    implements JARDirectoryProvider {
        private static final Map<URI, FileSystem> openedJars = new HashMap<URI, FileSystem>();
        private static final Set<JARDirectory> classPathDirectories = new HashSet<JARDirectory>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static FileSystem openOrGet(String uri) throws IOException {
            FileSystem fs;
            URI jarURI = URI.create(uri);
            Map<URI, FileSystem> map = openedJars;
            synchronized (map) {
                if (!openedJars.containsKey(jarURI)) {
                    fs = FileSystems.newFileSystem(jarURI, Collections.emptyMap());
                    openedJars.put(jarURI, fs);
                } else {
                    fs = openedJars.get(jarURI);
                }
            }
            return fs;
        }

        @Override
        public Directory get(URI uri, SemanticProperties semanticProperties) throws IOException {
            String jarFile = StringUtils.substringBefore((String)uri.toString(), (String)"!");
            String extractionRoot = semanticProperties.getSharedFolder();
            JARDirectory.JARDescriptor openedJar = new JARDirectory.JARDescriptor();
            StringTokenizer tokenizer = new StringTokenizer(uri.toString(), "!");
            FileSystem fs = null;
            while (tokenizer.hasMoreTokens()) {
                String current = tokenizer.nextToken();
                if (!tokenizer.hasMoreTokens()) break;
                if (fs == null) {
                    fs = BasicProvider.openOrGet(current);
                    continue;
                }
                Path path = fs.getPath(current, new String[0]);
                String unzipFile = extractionRoot + File.separator + path.getFileName();
                Path destFile = Paths.get(unzipFile, new String[0]);
                File destinationFile = destFile.toFile();
                if (!destinationFile.exists()) {
                    destinationFile.mkdirs();
                    Files.copy(path, destFile, StandardCopyOption.REPLACE_EXISTING);
                }
                fs = FileSystems.newFileSystem(destFile, Thread.currentThread().getContextClassLoader());
            }
            openedJar.fileSystem = fs;
            openedJar.jarFileName = jarFile;
            String directory = StringUtils.substringAfterLast((String)uri.toString(), (String)"!");
            LOGGER.debug("Creating JARDirectory for <{}>...", (Object)directory);
            JARDirectory jarDirectory = new JARDirectory(extractionRoot, openedJar, directory);
            classPathDirectories.add(jarDirectory);
            return jarDirectory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void destroy() {
            Iterator<JARDirectory> iterator = classPathDirectories.iterator();
            while (iterator.hasNext()) {
                JARDirectory jarDirectory = iterator.next();
                try {
                    jarDirectory.close();
                }
                catch (IOException e) {
                    LOGGER.error("Unable to close directory at " + jarDirectory.indexDirectory + " (location : " + jarDirectory.extractPath + ").", (Throwable)e);
                }
                finally {
                    iterator.remove();
                }
            }
            for (Map.Entry<URI, FileSystem> entry : openedJars.entrySet()) {
                try {
                    entry.getValue().close();
                }
                catch (IOException e) {
                    LOGGER.error("Unable to close " + entry.getValue() + ".", (Throwable)e);
                }
            }
        }
    }

    public static class SingletonProvider
    implements JARDirectoryProvider {
        private static final BasicProvider provider = new BasicProvider();
        private static final Map<URI, Directory> instances = new HashMap<URI, Directory>();

        @Override
        public synchronized Directory get(URI uri, SemanticProperties semanticProperties) throws IOException {
            Directory dir = instances.get(uri);
            if (dir == null) {
                instances.put(uri, provider.get(uri, semanticProperties));
            } else {
                try {
                    dir.listAll();
                }
                catch (AlreadyClosedException e) {
                    LOGGER.debug("Directory has already been closed. Re-extracting ...", (Throwable)e);
                    instances.put(uri, provider.get(uri, semanticProperties));
                }
            }
            return instances.get(uri);
        }

        @Override
        public void destroy() {
            provider.destroy();
        }
    }

    public static interface JARDirectoryProvider {
        public Directory get(URI var1, SemanticProperties var2) throws IOException;

        public void destroy();
    }
}

