/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.index;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.BytesRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataquality.semantic.exception.DQSemanticRuntimeException;
import org.talend.dataquality.semantic.index.AbstractDictionarySearcher;
import org.talend.dataquality.semantic.index.CachingFilterQuery;
import org.talend.dataquality.semantic.index.ClassPathDirectory;
import org.talend.dataquality.semantic.model.DQCategory;
import org.talend.dataquality.semantic.model.ValidationMode;

public class DictionarySearcher
extends AbstractDictionarySearcher
implements AutoCloseable {
    public static final String UNABLE_TO_OPEN_INDEX = "Unable to open synonym index.";
    private static final Logger LOGGER = LoggerFactory.getLogger(DictionarySearcher.class);
    private SearcherManager mgr;
    private final Map<String, Query> categoryToCachedQuery = new HashMap<String, Query>();
    private CachingFilterQuery categoryFilterQueryForDiscovery;

    public DictionarySearcher(String indexPath) {
        try (FSDirectory indexDir = FSDirectory.open((Path)Paths.get(indexPath, new String[0]));){
            this.mgr = new SearcherManager((Directory)indexDir, null);
        }
        catch (IOException e) {
            LOGGER.error(UNABLE_TO_OPEN_INDEX, (Throwable)e);
            throw new DQSemanticRuntimeException(UNABLE_TO_OPEN_INDEX, e);
        }
    }

    public DictionarySearcher(URI indexPathURI) {
        try (Directory indexDir = ClassPathDirectory.open(indexPathURI);){
            this.mgr = new SearcherManager(indexDir, null);
        }
        catch (IOException e) {
            LOGGER.error(UNABLE_TO_OPEN_INDEX, (Throwable)e);
            throw new DQSemanticRuntimeException(UNABLE_TO_OPEN_INDEX, e);
        }
    }

    public DictionarySearcher(Directory indexDir) {
        try {
            this.mgr = new SearcherManager(indexDir, null);
        }
        catch (IOException e) {
            LOGGER.error(UNABLE_TO_OPEN_INDEX, (Throwable)e);
            throw new DQSemanticRuntimeException(UNABLE_TO_OPEN_INDEX, e);
        }
    }

    public void setCategoriesToSearch(List<String> categoryIds) {
        Set<String> existingCatIds = this.getExistingCategories();
        if (existingCatIds.isEmpty()) {
            return;
        }
        HashSet<String> catIdsToSkip = new HashSet<String>(existingCatIds);
        catIdsToSkip.removeAll(categoryIds);
        if (catIdsToSkip.isEmpty()) {
            return;
        }
        BooleanQuery.Builder categoryFilterQueryBuilder = new BooleanQuery.Builder();
        for (String cat : catIdsToSkip) {
            TermQuery catQuery = new TermQuery(new Term("catid", cat));
            categoryFilterQueryBuilder.add((Query)catQuery, BooleanClause.Occur.SHOULD);
        }
        this.categoryFilterQueryForDiscovery = new CachingFilterQuery((Query)categoryFilterQueryBuilder.build());
    }

    private Set<String> getExistingCategories() {
        HashSet<String> existingCategories = new HashSet<String>();
        try {
            IndexSearcher searcher = (IndexSearcher)this.mgr.acquire();
            for (LeafReaderContext ctx : searcher.getIndexReader().getContext().leaves()) {
                TermsEnum termsEnum = ctx.reader().terms("catid").iterator();
                while (termsEnum.next() != null) {
                    BytesRef termBytesRef = termsEnum.term();
                    existingCategories.add(termBytesRef.utf8ToString());
                }
            }
            this.mgr.release((Object)searcher);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return existingCategories;
    }

    @Override
    public TopDocs searchDocumentBySynonym(String stringToSearch) throws IOException {
        Query query;
        switch (this.searchMode) {
            case MATCH_SEMANTIC_KEYWORD: {
                query = this.createQueryForSemanticKeywordMatch(stringToSearch);
                break;
            }
            default: {
                query = this.createQueryForSemanticDictionaryMatch(stringToSearch);
            }
        }
        IndexSearcher searcher = (IndexSearcher)this.mgr.acquire();
        BooleanQuery.Builder filteredQuery = new BooleanQuery.Builder();
        filteredQuery.add(query, BooleanClause.Occur.MUST);
        if (this.categoryFilterQueryForDiscovery != null) {
            filteredQuery.add((Query)this.categoryFilterQueryForDiscovery, BooleanClause.Occur.MUST_NOT);
        }
        TopDocs topDocs = searcher.search((Query)filteredQuery.build(), this.topDocLimit);
        this.mgr.release((Object)searcher);
        return topDocs;
    }

    @Override
    public Document getDocument(int docNum) {
        Document doc = null;
        try {
            IndexSearcher searcher = (IndexSearcher)this.mgr.acquire();
            doc = searcher.doc(docNum);
            this.mgr.release((Object)searcher);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return doc;
    }

    public boolean validDocumentWithCategories(String stringToSearch, DQCategory semanticType, Set<DQCategory> children) throws IOException {
        boolean hasChildren;
        Query query;
        switch (this.searchMode) {
            case MATCH_SEMANTIC_KEYWORD: {
                query = this.createQueryForSemanticKeywordMatch(stringToSearch);
                break;
            }
            default: {
                query = this.createQueryForSemanticDictionaryMatch(stringToSearch);
            }
        }
        IndexSearcher searcher = (IndexSearcher)this.mgr.acquire();
        Query cachedCategoryQuery = this.categoryToCachedQuery.get(semanticType.getId());
        boolean bl = hasChildren = !CollectionUtils.isEmpty(children);
        if (cachedCategoryQuery == null) {
            if (hasChildren) {
                BooleanQuery.Builder catQueryBuilder = new BooleanQuery.Builder();
                for (DQCategory category : children) {
                    catQueryBuilder.add((Query)new TermQuery(new Term("catid", category.getId())), BooleanClause.Occur.SHOULD);
                }
                cachedCategoryQuery = catQueryBuilder.build();
            } else {
                cachedCategoryQuery = new TermQuery(new Term("catid", semanticType.getId()));
            }
            this.categoryToCachedQuery.put(semanticType.getId(), cachedCategoryQuery);
        }
        BooleanQuery.Builder filteredQueryBuilder = new BooleanQuery.Builder();
        filteredQueryBuilder.add(query, BooleanClause.Occur.MUST);
        filteredQueryBuilder.add(cachedCategoryQuery, BooleanClause.Occur.FILTER);
        TopDocs docs = searcher.search((Query)filteredQueryBuilder.build(), this.topDocLimit);
        ValidationMode validationMode = ValidationMode.EXACT;
        if (!hasChildren && semanticType.getValidationMode() != null && ValidationMode.SIMPLIFIED.equals((Object)(validationMode = semanticType.getValidationMode()))) {
            this.mgr.release((Object)searcher);
            return docs.totalHits.value != 0L;
        }
        boolean validDocument = false;
        for (int i = 0; i < docs.scoreDocs.length && !validDocument; ++i) {
            Document document = searcher.doc(docs.scoreDocs[i].doc);
            if (hasChildren) {
                validationMode = this.getChildrenValidationMode(children, document);
            }
            validDocument = this.validDocumentByValidationMode(document, stringToSearch, validationMode);
        }
        this.mgr.release((Object)searcher);
        return validDocument;
    }

    private ValidationMode getChildrenValidationMode(Set<DQCategory> children, Document document) {
        for (DQCategory child : children) {
            if (!child.getId().equals(document.getField("catid").stringValue())) continue;
            return child.getValidationMode() != null ? child.getValidationMode() : ValidationMode.EXACT;
        }
        LOGGER.error("The document does not belong to any children category");
        return ValidationMode.EXACT;
    }

    private boolean validDocumentByValidationMode(Document document, String stringToSearch, ValidationMode validationMode) {
        if (ValidationMode.SIMPLIFIED.equals((Object)validationMode)) {
            return true;
        }
        String transformedString = this.transformStringByValidationMode(stringToSearch, validationMode);
        if (!StringUtils.isEmpty((CharSequence)transformedString)) {
            for (String raw : document.getValues("raw")) {
                if (!transformedString.equals(this.transformStringByValidationMode(raw, validationMode))) continue;
                return true;
            }
        }
        return false;
    }

    private String transformStringByValidationMode(String stringToTransform, ValidationMode validationMode) {
        if (ValidationMode.EXACT_IGNORE_CASE_AND_ACCENT.equals((Object)validationMode)) {
            return StringUtils.stripAccents((String)stringToTransform.toLowerCase());
        }
        return stringToTransform;
    }

    public String getWordByDocNumber(int docNo) {
        Document document = this.getDocument(docNo);
        return document != null ? document.getValues("word")[0] : null;
    }

    public String[] getSynonymsByDocNumber(int docNo) {
        Document document = this.getDocument(docNo);
        return document != null ? document.getValues("raw") : null;
    }

    public int getNumDocs() {
        try {
            IndexSearcher searcher = (IndexSearcher)this.mgr.acquire();
            int numDocs = searcher.getIndexReader().numDocs();
            this.mgr.release((Object)searcher);
            return numDocs;
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    @Override
    public void close() {
        try {
            this.mgr.close();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void maybeRefreshIndex() {
        try {
            this.mgr.maybeRefresh();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalStateException("Failed to refresh index");
        }
    }

    public TopDocs findSimilarValuesInCategory(String input, String category) throws IOException {
        BooleanQuery.Builder combinedQueryBuilder = new BooleanQuery.Builder();
        if (category != null && !"".equals(category)) {
            Term catTerm = new Term("word", category);
            TermQuery catQuery = new TermQuery(catTerm);
            combinedQueryBuilder.add((Query)catQuery, BooleanClause.Occur.MUST);
        }
        BooleanQuery.Builder valueQueryBuilder = new BooleanQuery.Builder();
        List<String> tokens = DictionarySearcher.getTokensFromAnalyzer(input);
        Query inputTermQuery = this.getTermQuery("synterm", StringUtils.join(tokens, (char)' '), true);
        valueQueryBuilder.add(inputTermQuery, BooleanClause.Occur.SHOULD);
        BooleanQuery.Builder inputTokenQueryBuilder = new BooleanQuery.Builder();
        for (String token : tokens) {
            inputTokenQueryBuilder.add(this.getTermQuery("synterm", token, true), BooleanClause.Occur.SHOULD);
        }
        valueQueryBuilder.add((Query)inputTokenQueryBuilder.build(), BooleanClause.Occur.SHOULD);
        combinedQueryBuilder.add((Query)valueQueryBuilder.build(), BooleanClause.Occur.MUST);
        IndexSearcher searcher = (IndexSearcher)this.mgr.acquire();
        TopDocs topDocs = searcher.search((Query)combinedQueryBuilder.build(), 50);
        this.mgr.release((Object)searcher);
        return topDocs;
    }

    public List<Document> listDocumentsByCategoryId(String catId) {
        return this.listDocumentsByCategoryId(catId, 0, Integer.MAX_VALUE);
    }

    public List<Document> listDocumentsByCategoryId(String catId, int offset, int n) {
        try {
            TopDocs topDocs;
            IndexSearcher searcher = (IndexSearcher)this.mgr.acquire();
            IndexReader reader = searcher.getIndexReader();
            Term catTerm = new Term("catid", catId);
            TermQuery catQuery = new TermQuery(catTerm);
            if (offset <= 0) {
                topDocs = searcher.search((Query)catQuery, n);
            } else {
                TopDocs docs = searcher.search((Query)catQuery, offset + n);
                TermQuery q = new TermQuery(new Term("catid", catId));
                topDocs = searcher.searchAfter(docs.scoreDocs[(int)Math.min(docs.totalHits.value, (long)offset) - 1], (Query)q, n);
            }
            ArrayList<Document> listDocs = new ArrayList<Document>();
            for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                Document luceneDoc = reader.document(scoreDoc.doc);
                listDocs.add(luceneDoc);
            }
            this.mgr.release((Object)searcher);
            return listDocs;
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<String> searchPhraseInSemanticCategory(String catId, String phrase) {
        Query catQuery = this.getTermQuery("catid", catId, false);
        String filteredString = StringUtils.join(DictionarySearcher.getTokensFromAnalyzer(phrase), (char)' ');
        PrefixQuery syntermQuery = new PrefixQuery(new Term("synterm", filteredString));
        BooleanQuery.Builder combinedQueryBuilder = new BooleanQuery.Builder();
        combinedQueryBuilder.add(catQuery, BooleanClause.Occur.MUST);
        combinedQueryBuilder.add((Query)syntermQuery, BooleanClause.Occur.MUST);
        try {
            IndexSearcher searcher = (IndexSearcher)this.mgr.acquire();
            IndexReader reader = searcher.getIndexReader();
            TopDocs topDocs = searcher.search((Query)combinedQueryBuilder.build(), 1000);
            ArrayList<String> listDocs = new ArrayList<String>();
            for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                Document luceneDoc = reader.document(scoreDoc.doc);
                listDocs.addAll(Arrays.asList(luceneDoc.getValues("raw")));
            }
            this.mgr.release((Object)searcher);
            return listDocs;
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public SearcherManager getSearcherManager() {
        return this.mgr;
    }
}

