/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.recognizer;

import org.talend.dataquality.record.linkage.attribute.AbstractAttributeMatcher;
import org.talend.dataquality.record.linkage.attribute.LevenshteinMatcher;
import org.talend.dataquality.record.linkage.constant.TokenizedResolutionMethod;
import org.talend.dataquality.semantic.classifier.SemanticCategoryEnum;
import org.talend.dataquality.semantic.model.DQCategory;

public class CategoryHelper {
    public static final float DEFAULT_WEIGHT_VALUE = 0.1f;
    private static final CategoryHelper INSTANCE = new CategoryHelper();
    private final AbstractAttributeMatcher columnMatcher = new LevenshteinMatcher();

    public static CategoryHelper getInstance() {
        return INSTANCE;
    }

    private CategoryHelper() {
        this.columnMatcher.setFingerPrintApply(true);
        this.columnMatcher.setTokenMethod(TokenizedResolutionMethod.ANYORDER);
    }

    public float computeScore(long nbHit, long total) {
        return (float)nbHit * 100.0f / (float)total;
    }

    public float computeAdjustedScore(String categoryLabel, String columnName, long nbHit, long total, float weight) {
        return this.adjustScoreWithColumnName(this.computeScore(nbHit, total), categoryLabel, columnName, weight);
    }

    public float computeAdjustedScore(String categoryLabel, String columnName, long nbHit, long total) {
        return this.adjustScoreWithColumnName(this.computeScore(nbHit, total), categoryLabel, columnName);
    }

    public float adjustScoreWithColumnName(float score, String categoryLabel, String columnName) {
        return this.adjustScoreWithColumnName(score, categoryLabel, columnName, 0.1f);
    }

    public float adjustScoreWithColumnName(float score, String categoryLabel, String columnName, float weight) {
        float scoreOnHeader;
        if (columnName != null && !SemanticCategoryEnum.UNKNOWN.getDisplayName().equals(categoryLabel) && (double)(scoreOnHeader = (float)this.columnMatcher.getMatchingWeight(columnName, categoryLabel)) > 0.7) {
            score += scoreOnHeader * weight * 100.0f;
        }
        return Math.min((float)Math.round(score * 100.0f) / 100.0f, 100.0f);
    }

    public int computeCategoryLevel(DQCategory category, int currentDepth) {
        if (category.getChildren() == null) {
            return currentDepth;
        }
        return category.getChildren().stream().mapToInt(child -> this.computeCategoryLevel((DQCategory)child, currentDepth + 1)).max().orElse(currentDepth);
    }
}

