/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.recognizer;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.talend.dataquality.common.util.LFUCache;
import org.talend.dataquality.semantic.classifier.ISubCategory;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedClassifier;
import org.talend.dataquality.semantic.classifier.impl.DataDictFieldClassifier;
import org.talend.dataquality.semantic.index.Index;
import org.talend.dataquality.semantic.model.CategoryType;
import org.talend.dataquality.semantic.model.DQCategory;
import org.talend.dataquality.semantic.model.MainCategory;
import org.talend.dataquality.semantic.recognizer.CategoryFrequency;
import org.talend.dataquality.semantic.recognizer.CategoryHelper;
import org.talend.dataquality.semantic.recognizer.CategoryRecognizer;
import org.talend.dataquality.semantic.snapshot.DictionarySnapshot;

public class DefaultCategoryRecognizer
implements CategoryRecognizer {
    private final List<CategoryFrequency> catList = new ArrayList<CategoryFrequency>();
    private final DataDictFieldClassifier dataDictFieldClassifier;
    private final UserDefinedClassifier userDefineClassifier;
    private final Map<String, DQCategory> metadata;
    private Map<String, CategoryFrequency> categoryToFrequency = new HashMap<String, CategoryFrequency>();
    private LFUCache<String, Set<String>> knownCategoryCache = new LFUCache(10, 1000, 0.01f);
    private long total = 0L;

    public DefaultCategoryRecognizer(DictionarySnapshot dictionarySnapshot) {
        this(dictionarySnapshot.getSharedDataDict(), dictionarySnapshot.getCustomDataDict(), dictionarySnapshot.getKeyword(), dictionarySnapshot.getRegexClassifier(), dictionarySnapshot.getMetadata());
    }

    public DefaultCategoryRecognizer(Index sharedDictionary, Index customDictionary, Index keyword, UserDefinedClassifier regex, Map<String, DQCategory> metadata) {
        HashSet<ISubCategory> classifiers = new HashSet<ISubCategory>(regex.getClassifiers());
        classifiers.removeIf(classifier -> metadata.get(classifier.getId()) != null && Boolean.TRUE.equals(((DQCategory)metadata.get(classifier.getId())).getDeleted()));
        this.userDefineClassifier = new UserDefinedClassifier();
        this.userDefineClassifier.setClassifiers(classifiers);
        this.metadata = metadata;
        ArrayList<String> sharedCategories = new ArrayList<String>();
        ArrayList<String> customCategories = new ArrayList<String>();
        for (DQCategory cat : metadata.values()) {
            if (cat.getDeleted().booleanValue() || !CategoryType.DICT.equals((Object)cat.getType())) continue;
            if (cat.getModified().booleanValue()) {
                customCategories.add(cat.getId());
                continue;
            }
            sharedCategories.add(cat.getId());
        }
        sharedDictionary.setCategoriesToSearch(sharedCategories);
        if (customDictionary != null) {
            customDictionary.setCategoriesToSearch(customCategories);
        }
        this.dataDictFieldClassifier = new DataDictFieldClassifier(sharedDictionary, customDictionary, keyword);
    }

    @Override
    public DataDictFieldClassifier getDataDictFieldClassifier() {
        return this.dataDictFieldClassifier;
    }

    @Override
    public UserDefinedClassifier getUserDefineClassifier() {
        return this.userDefineClassifier;
    }

    public Set<String> getSubCategorySet(String data) {
        if (data == null || "".equals(data.trim())) {
            return new HashSet<String>();
        }
        Set knownCategory = (Set)this.knownCategoryCache.get((Object)data);
        if (knownCategory != null) {
            return knownCategory;
        }
        MainCategory mainCategory = MainCategory.getMainCategory((String)data);
        HashSet<String> subCategorySet = new HashSet<String>();
        switch (mainCategory) {
            case Alpha: 
            case Numeric: 
            case AlphaNumeric: {
                this.handleAlphaNumericCase(subCategorySet, data, mainCategory);
                break;
            }
            case NULL: 
            case BLANK: {
                break;
            }
        }
        return subCategorySet;
    }

    private void handleAlphaNumericCase(Set<String> subCategorySet, String data, MainCategory mainCategory) {
        subCategorySet.addAll(this.dataDictFieldClassifier.classify(data));
        if (this.userDefineClassifier != null) {
            subCategorySet.addAll(this.userDefineClassifier.classify(data, mainCategory));
        }
        this.knownCategoryCache.put((Object)data, subCategorySet);
    }

    @Override
    public void prepare() {
        this.categoryToFrequency = new HashMap<String, CategoryFrequency>();
        this.knownCategoryCache = new LFUCache(10, 1000, 0.01f);
    }

    @Override
    public void reset() {
        this.catList.clear();
        if (this.categoryToFrequency != null) {
            this.categoryToFrequency.clear();
        }
        this.total = 0L;
        if (this.knownCategoryCache != null) {
            this.knownCategoryCache.clear();
        }
        this.categoryToFrequency = null;
        this.knownCategoryCache = null;
    }

    @Override
    public String[] process(String data) {
        Set<String> ids = this.getSubCategorySet(data);
        HashMap<String, Integer> categoryToLevel = new HashMap<String, Integer>();
        ArrayList<String> categories = new ArrayList<String>();
        if (!ids.isEmpty()) {
            DQCategory meta;
            for (String string : ids) {
                categoryToLevel.put(string, 0);
                meta = this.metadata.get(string);
                if (meta == null || CollectionUtils.isEmpty((Collection)meta.getParents())) continue;
                this.incrementAncestorsCategories(categoryToLevel, string);
            }
            for (Map.Entry entry : categoryToLevel.entrySet()) {
                meta = this.metadata.get(entry.getKey());
                if (meta == null) continue;
                categories.add(meta.getName());
                this.incrementCategory(meta.getName(), meta.getLabel(), (Integer)entry.getValue());
            }
        } else {
            this.incrementCategory();
        }
        ++this.total;
        return categories.toArray(new String[0]);
    }

    private void incrementAncestorsCategories(Map<String, Integer> categoryToLevel, String id) {
        ArrayDeque<String> catToSee = new ArrayDeque<String>();
        catToSee.add(id);
        while (!catToSee.isEmpty()) {
            String currentCategory = (String)catToSee.pop();
            DQCategory dqCategory = this.metadata.get(currentCategory);
            Integer categoryLevel = categoryToLevel.get(currentCategory);
            if (dqCategory == null || CollectionUtils.isEmpty((Collection)dqCategory.getParents())) continue;
            this.updateAncestorsCategoryLevel(dqCategory.getParents(), categoryLevel, categoryToLevel, catToSee);
        }
    }

    private void updateAncestorsCategoryLevel(List<DQCategory> parents, Integer categoryLevel, Map<String, Integer> categoryToLevel, Deque<String> catToSee) {
        for (DQCategory parent : parents) {
            String parentId = parent.getId();
            Integer level = categoryToLevel.get(parentId);
            if (level != null && level >= categoryLevel + 1) continue;
            categoryToLevel.put(parentId, categoryLevel + 1);
            catToSee.add(parentId);
        }
    }

    private void incrementCategory() {
        this.incrementCategory("", "", 0);
    }

    private void incrementCategory(String categoryName, String categoryLabel, int categoryLevel) {
        CategoryFrequency c = this.categoryToFrequency.get(categoryName);
        if (c == null) {
            c = new CategoryFrequency(categoryName, categoryLabel, categoryLevel);
            this.categoryToFrequency.put(categoryName, c);
            this.catList.add(c);
        }
        ++c.count;
    }

    @Override
    @Deprecated
    public Collection<CategoryFrequency> getResult() {
        for (CategoryFrequency category : this.categoryToFrequency.values()) {
            category.score = (float)(category.count * 10000L / this.total) / 100.0f;
        }
        this.catList.sort(Collections.reverseOrder());
        return this.catList;
    }

    @Override
    public Collection<CategoryFrequency> getResult(String columnName, float weight) {
        CategoryHelper helper = CategoryHelper.getInstance();
        for (CategoryFrequency category : this.categoryToFrequency.values()) {
            category.score = helper.computeAdjustedScore(category.getCategoryName(), columnName, category.count, this.total, weight);
        }
        this.catList.sort(Collections.reverseOrder());
        return this.catList;
    }

    @Override
    public void end() {
        this.reset();
    }

    public long getTotal() {
        return this.total;
    }
}

