/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.sampling;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataquality.semantic.api.CategoryMetadataUtils;
import org.talend.dataquality.semantic.classifier.custom.UDCategorySerDeser;
import org.talend.dataquality.semantic.index.ClassPathDirectory;
import org.talend.dataquality.semantic.index.DictionarySearchMode;
import org.talend.dataquality.semantic.index.LuceneIndex;
import org.talend.dataquality.semantic.recognizer.CategoryFrequency;
import org.talend.dataquality.semantic.recognizer.CategoryRecognizer;
import org.talend.dataquality.semantic.recognizer.DefaultCategoryRecognizer;
import org.talend.dataquality.semantic.sampling.SemanticCategory;
import org.talend.dataquality.semantic.snapshot.DictionarySnapshot;

public class CategoryInferenceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CategoryInferenceManager.class);
    private final Map<Integer, CategoryRecognizer> categoryRecognizers = new HashMap<Integer, CategoryRecognizer>();
    private final DictionarySnapshot dictionarySnapshot = this.getSharedDictionarySnapshot();

    private DictionarySnapshot getSharedDictionarySnapshot() {
        try {
            URI metadataUri = this.getClass().getResource("/metadata/").toURI();
            URI dictUri = this.getClass().getResource("/dictionary/").toURI();
            URI keywordUri = this.getClass().getResource("/keyword/").toURI();
            return new DictionarySnapshot(CategoryMetadataUtils.loadMetadataFromIndex(ClassPathDirectory.open(metadataUri)), new LuceneIndex(dictUri, DictionarySearchMode.MATCH_SEMANTIC_DICTIONARY), null, new LuceneIndex(keywordUri, DictionarySearchMode.MATCH_SEMANTIC_KEYWORD), UDCategorySerDeser.getRegexClassifier());
        }
        catch (IOException | URISyntaxException e) {
            LOGGER.error("Failed to create DictionarySnapshot for shared dictionaries!", (Throwable)e);
            return null;
        }
    }

    public Map<Integer, List<SemanticCategory>> getSemanticCategory() {
        HashMap<Integer, List<SemanticCategory>> categories = new HashMap<Integer, List<SemanticCategory>>();
        for (Map.Entry<Integer, CategoryRecognizer> entry : this.categoryRecognizers.entrySet()) {
            Integer colIdx = entry.getKey();
            CategoryRecognizer categoryRecognizer = entry.getValue();
            ArrayList<SemanticCategory> categoryList = new ArrayList<SemanticCategory>();
            Collection<CategoryFrequency> result = categoryRecognizer.getResult();
            for (CategoryFrequency frequencyTableItem : result) {
                SemanticCategory category = new SemanticCategory(frequencyTableItem.getCategoryId(), frequencyTableItem.getCategoryName(), frequencyTableItem.getCount(), frequencyTableItem.getFrequency());
                categoryList.add(category);
            }
            categories.put(colIdx, categoryList);
        }
        return categories;
    }

    public boolean inferCategory(Object[] record) {
        int colIdx = 0;
        for (Object fieldData : record) {
            CategoryRecognizer categoryRecognizer = this.categoryRecognizers.get(colIdx);
            if (categoryRecognizer == null) {
                categoryRecognizer = this.newCategoryRecognizer();
                categoryRecognizer.prepare();
                this.categoryRecognizers.put(colIdx, categoryRecognizer);
            }
            categoryRecognizer.process(fieldData == null ? null : fieldData.toString());
            ++colIdx;
        }
        return true;
    }

    private CategoryRecognizer newCategoryRecognizer() {
        return new DefaultCategoryRecognizer(this.dictionarySnapshot);
    }
}

