/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.snapshot;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedClassifier;
import org.talend.dataquality.semantic.exception.DQSemanticRuntimeException;
import org.talend.dataquality.semantic.index.Index;
import org.talend.dataquality.semantic.model.DQCategory;
import org.talend.dataquality.semantic.snapshot.DictionarySnapshot;

public class DeletableDictionarySnapshot
extends DictionarySnapshot {
    private static final long serialVersionUID = 5258952436706771341L;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String indexFolder;
    private final AtomicBoolean deleted = new AtomicBoolean(false);
    private final AtomicInteger useCount = new AtomicInteger(0);

    public DeletableDictionarySnapshot(Map<String, DQCategory> metadata, Index sharedDataDict, Index customDataDict, Index keyword, UserDefinedClassifier regexClassifier, String indexFolder) {
        super(metadata, sharedDataDict, customDataDict, keyword, regexClassifier);
        this.indexFolder = indexFolder;
    }

    public void delete() {
        this.deleted.set(true);
        this.deleteIfUnused();
    }

    private void deleteIfUnused() {
        if (this.deleted.get() && this.useCount.get() <= 0) {
            this.deleteIndexFolder();
        }
    }

    private void deleteIndexFolder() {
        this.releaseIndexes();
        File rootFolder = new File(this.indexFolder);
        try {
            FileUtils.deleteDirectory((File)rootFolder);
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized DeletableDictionarySnapshot bind() {
        this.useCount.incrementAndGet();
        return this;
    }

    public synchronized void release() {
        int i = this.useCount.decrementAndGet();
        if (i < 0) {
            DQSemanticRuntimeException error = new DQSemanticRuntimeException("Too many release or missing bind call");
            this.log.error("Bad usage of DeletableDictionarySnapshot too many release call", (Throwable)error);
            throw error;
        }
        this.deleteIfUnused();
    }

    @Override
    public void close() {
        this.release();
    }

    public int getUseCount() {
        return this.useCount.get();
    }

    public boolean isDeleted() {
        return this.deleted.get();
    }
}

