/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.snapshot;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.SerializationUtils;
import org.talend.dataquality.semantic.api.LocalDictionaryCache;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedClassifier;
import org.talend.dataquality.semantic.index.Index;
import org.talend.dataquality.semantic.model.CategoryType;
import org.talend.dataquality.semantic.model.DQCategory;

public class DictionarySnapshot
implements Serializable,
AutoCloseable {
    private static final long serialVersionUID = -6215879188951573104L;
    private final Map<String, DQCategory> metadata = new HashMap<String, DQCategory>();
    private final Index sharedDataDict;
    private final Index customDataDict;
    private final Index keyword;
    private final UserDefinedClassifier regexClassifier;
    private transient LocalDictionaryCache localDictionaryCache;

    public DictionarySnapshot(Map<String, DQCategory> metadata, Index sharedDataDict, Index customDataDict, Index keyword, UserDefinedClassifier regexClassifier) {
        metadata.forEach((key, value) -> this.metadata.put((String)key, (DQCategory)SerializationUtils.clone((Serializable)value)));
        this.sharedDataDict = sharedDataDict;
        this.customDataDict = customDataDict;
        this.keyword = keyword;
        this.regexClassifier = (UserDefinedClassifier)SerializationUtils.clone((Serializable)regexClassifier);
    }

    public Map<String, DQCategory> getMetadata() {
        return this.metadata;
    }

    public DQCategory getDQCategoryByName(String categoryName) {
        DQCategory dqCategory = null;
        for (DQCategory dqCat : this.getMetadata().values()) {
            if (!dqCat.getName().equals(categoryName)) continue;
            dqCategory = dqCat;
            break;
        }
        return dqCategory;
    }

    public DQCategory getDQCategoryById(String categoryId) {
        DQCategory dqCategory = null;
        for (DQCategory dqCat : this.getMetadata().values()) {
            if (!dqCat.getId().equals(categoryId)) continue;
            dqCategory = dqCat;
            break;
        }
        return dqCategory;
    }

    public Index getSharedDataDict() {
        return this.sharedDataDict;
    }

    public Index getCustomDataDict() {
        return this.customDataDict;
    }

    public Index getKeyword() {
        return this.keyword;
    }

    public UserDefinedClassifier getRegexClassifier() {
        return this.regexClassifier;
    }

    @Override
    public void close() {
        this.releaseIndexes();
    }

    public Collection<DQCategory> listCategories() {
        return this.listCategories(true);
    }

    public Collection<DQCategory> listCategories(boolean includeOpenCategories) {
        ArrayList<DQCategory> catList = new ArrayList<DQCategory>();
        for (DQCategory dqCat : this.getMetadata().values()) {
            if (!includeOpenCategories && !dqCat.getCompleteness().booleanValue()) continue;
            catList.add(dqCat);
        }
        return catList;
    }

    public List<DQCategory> listCategories(CategoryType type) {
        ArrayList<DQCategory> catList = new ArrayList<DQCategory>();
        for (DQCategory dqCat : this.getMetadata().values()) {
            if (!type.equals((Object)dqCat.getType())) continue;
            catList.add(dqCat);
        }
        return catList;
    }

    public DQCategory getCategoryMetadataById(String catId) {
        return this.getMetadata().get(catId);
    }

    public DQCategory getCategoryMetadataByName(String catName) {
        return this.findCategoryMetadataByName(catName).orElse(null);
    }

    public Optional<DQCategory> findCategoryMetadataByName(String catName) {
        for (DQCategory cat : this.getMetadata().values()) {
            if (!cat.getName().equals(catName)) continue;
            return Optional.of(cat);
        }
        return Optional.empty();
    }

    public synchronized LocalDictionaryCache getLocalDictionaryCache() {
        if (this.localDictionaryCache == null) {
            this.localDictionaryCache = new LocalDictionaryCache(this);
        }
        return this.localDictionaryCache;
    }

    public String findMostSimilarValue(String input, String categoryName, double similarity) {
        return this.findCategoryMetadataByName(categoryName).map(category -> this.findMostSimilarValue(input, (DQCategory)category, similarity)).orElse(input);
    }

    private String findMostSimilarValue(String input, DQCategory category, double similarity) {
        Index index = this.getLuceneIndex(category);
        List<String> categoriesToSearch = this.findDictionaries(category);
        return index.findMostSimilarFieldInCategories(input, categoriesToSearch, similarity);
    }

    private List<String> findDictionaries(DQCategory category) {
        ArrayList<String> catNames = new ArrayList<String>();
        switch (category.getType()) {
            case DICT: {
                catNames.add(category.getName());
                break;
            }
            case COMPOUND: {
                for (DQCategory child : category.getChildren()) {
                    DQCategory childDetails = this.getCategoryMetadataById(child.getId());
                    catNames.addAll(this.findDictionaries(childDetails));
                }
                break;
            }
        }
        return catNames;
    }

    Index getLuceneIndex(DQCategory category) {
        if (category.getModified().booleanValue()) {
            return this.customDataDict;
        }
        return this.sharedDataDict;
    }

    public Map<String, Double> findSimilarValues(String input, String categoryName, double similarity) {
        return this.findCategoryMetadataByName(categoryName).map(it -> this.findSimilarValues(input, (DQCategory)it, similarity)).orElse(Collections.emptyMap());
    }

    private Map<String, Double> findSimilarValues(String input, DQCategory category, double similarity) {
        Index index = this.getLuceneIndex(category);
        List<String> categoriesToSearch = this.findDictionaries(category);
        return index.findSimilarFieldsInCategories(input, categoriesToSearch, similarity);
    }

    protected void releaseIndexes() {
        this.sharedDataDict.closeIndex();
        if (null != this.customDataDict) {
            this.customDataDict.closeIndex();
        }
        this.keyword.closeIndex();
    }
}

