/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.snapshot;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.talend.dataquality.semantic.api.CategoryMetadataUtils;
import org.talend.dataquality.semantic.api.SemanticProperties;
import org.talend.dataquality.semantic.classifier.custom.UDCategorySerDeser;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedClassifier;
import org.talend.dataquality.semantic.exception.DQSemanticRuntimeException;
import org.talend.dataquality.semantic.index.ClassPathDirectory;
import org.talend.dataquality.semantic.model.DQCategory;

public class SharedDictionary
implements AutoCloseable {
    private final ImmutableMap<String, DQCategory> categoryMetadata;
    private final Directory dataDictDirectory;
    private final Directory keywordDirectory;
    private final UserDefinedClassifier regexClassifier;

    public SharedDictionary(SemanticProperties properties) {
        this.categoryMetadata = this.readCategoryMetadata(properties);
        this.dataDictDirectory = ClassPathDirectory.open(properties.getSharedDictionaryURI());
        this.keywordDirectory = ClassPathDirectory.open(properties.getSharedKeywordURI());
        this.regexClassifier = this.readRegexClassifier(properties);
    }

    private ImmutableMap<String, DQCategory> readCategoryMetadata(SemanticProperties properties) {
        File categorySubFolder = new File(properties.getSharedMetadataURI());
        try {
            return ImmutableMap.copyOf(CategoryMetadataUtils.loadMetadataFromIndex((Directory)FSDirectory.open((Path)categorySubFolder.toPath())));
        }
        catch (IOException e) {
            throw new DQSemanticRuntimeException("Cannot read shared metadata", e);
        }
    }

    private UserDefinedClassifier readRegexClassifier(SemanticProperties properties) {
        File regexRegistryFile = new File(properties.getSharedRegexFileURI());
        try {
            return UDCategorySerDeser.readJsonFile(regexRegistryFile.toURI());
        }
        catch (IOException e) {
            throw new DQSemanticRuntimeException("Cannot read shared regex", e);
        }
    }

    public ImmutableMap<String, DQCategory> getCategoryMetadata() {
        return this.categoryMetadata;
    }

    public Directory getDataDictDirectory() {
        return this.dataDictDirectory;
    }

    public Directory getKeywordDirectory() {
        return this.keywordDirectory;
    }

    public UserDefinedClassifier getRegexClassifier() {
        return this.regexClassifier;
    }

    @Override
    public void close() {
        try {
            this.dataDictDirectory.close();
            this.keywordDirectory.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

