/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.statistics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.talend.dataquality.common.inference.AvroQualityAnalyzer;
import org.talend.dataquality.common.inference.ValueQualityStatistics;
import org.talend.dataquality.common.util.AvroUtils;
import org.talend.dataquality.semantic.classifier.SemanticCategoryEnum;
import org.talend.dataquality.semantic.model.DQCategory;
import org.talend.dataquality.semantic.snapshot.DictionarySnapshot;
import org.talend.dataquality.semantic.statistics.CommonQualityAnalyzer;

public class AvroSemanticQualityAnalyzer
extends AvroQualityAnalyzer {
    private static final long serialVersionUID = 9184052763107787540L;
    private Map<String, String> fieldCategories;
    private final CommonQualityAnalyzer commonQualityAnalyzer;

    public AvroSemanticQualityAnalyzer(DictionarySnapshot dictionarySnapshot, boolean isStoreInvalidValues) {
        this.commonQualityAnalyzer = new CommonQualityAnalyzer(dictionarySnapshot, isStoreInvalidValues);
    }

    public AvroSemanticQualityAnalyzer(DictionarySnapshot dictionarySnapshot) {
        this(dictionarySnapshot, true);
    }

    public void init() {
        this.commonQualityAnalyzer.init();
        this.qualityResults.clear();
    }

    public void init(Schema semanticSchema) {
        this.init();
        this.initResultSchema(AvroUtils.dereferencing((Schema)semanticSchema));
    }

    private void initResultSchema(Schema semanticSchema) {
        this.fieldCategories = new HashMap<String, String>();
        Map dqTypes = AvroUtils.extractProperties((Schema)semanticSchema, (String)"talend.component.dqType");
        for (Map.Entry entry : dqTypes.entrySet()) {
            String fieldSemanticTypeName = (String)((Map)entry.getValue()).get("dqType");
            DQCategory dqCat = this.commonQualityAnalyzer.getDictionarySnapshot().getDQCategoryByName(fieldSemanticTypeName);
            if (dqCat == null) {
                this.fieldCategories.put((String)entry.getKey(), SemanticCategoryEnum.UNKNOWN.name());
                continue;
            }
            this.fieldCategories.put((String)entry.getKey(), dqCat.getId());
        }
        this.inputSemanticSchema = semanticSchema;
        this.outputSemanticSchema = AvroUtils.copySchema((Schema)this.inputSemanticSchema);
        this.outputRecordSemanticSchema = AvroUtils.createRecordSemanticSchema((Schema)this.inputSemanticSchema, (Schema)QUALITY_VALUE_LEVEL_SCHEMA);
    }

    public Stream<IndexedRecord> analyze(Stream<IndexedRecord> records) {
        return ((Stream)records.sequential()).map(this::analyzeRecord);
    }

    public boolean analyze(IndexedRecord record) {
        this.analyzeRecord(record);
        return true;
    }

    private IndexedRecord analyzeRecord(IndexedRecord record) {
        if (record == null) {
            return null;
        }
        if (this.inputSemanticSchema == null) {
            this.initResultSchema(record.getSchema());
        }
        GenericData.Record resultRecord = new GenericData.Record(this.outputRecordSemanticSchema);
        this.analyzeRecord("", record, (GenericRecord)resultRecord, this.inputSemanticSchema);
        return resultRecord;
    }

    private void analyzeRecord(String id, IndexedRecord record, GenericRecord resultRecord, Schema recordSemanticSchema) {
        Schema schema = record.getSchema();
        for (Schema.Field field : schema.getFields()) {
            String itemId = AvroUtils.itemId((String)id, (String)field.name());
            Schema fieldResultSchema = resultRecord.getSchema().getField(field.name()).schema();
            Schema fieldSemanticSchema = recordSemanticSchema.getField(field.name()).schema();
            Object semRecord = this.analyzeItem(itemId, record.get(field.pos()), field.schema(), fieldResultSchema, fieldSemanticSchema);
            resultRecord.put(field.name(), semRecord);
        }
    }

    private Object analyzeItem(String itemId, Object item, Schema itemSchema, Schema resultSchema, Schema semanticSchema) {
        switch (itemSchema.getType()) {
            case RECORD: {
                GenericData.Record resultRecord = new GenericData.Record(resultSchema);
                this.analyzeRecord(itemId, (IndexedRecord)((GenericRecord)item), (GenericRecord)resultRecord, semanticSchema);
                return resultRecord;
            }
            case ARRAY: {
                ArrayList<Object> resultArray = new ArrayList<Object>();
                for (Object obj : (List)item) {
                    resultArray.add(this.analyzeItem(itemId, obj, itemSchema.getElementType(), resultSchema.getElementType(), semanticSchema.getElementType()));
                }
                return new GenericData.Array(resultSchema, resultArray);
            }
            case MAP: {
                Map itemMap = (Map)item;
                HashMap resultMap = new HashMap();
                for (Map.Entry itemValue : itemMap.entrySet()) {
                    resultMap.put(itemValue.getKey(), this.analyzeItem(itemId, itemValue.getValue(), itemSchema.getValueType(), resultSchema.getValueType(), semanticSchema.getValueType()));
                }
                return resultMap;
            }
            case UNION: {
                int typeIdx = new GenericData().resolveUnion(itemSchema, item);
                List unionSchemas = itemSchema.getTypes();
                Schema realItemSchema = (Schema)unionSchemas.get(typeIdx);
                Schema realResultSchema = resultSchema.getTypes().stream().filter(type -> type.getName().equals(realItemSchema.getName())).findFirst().orElse(QUALITY_VALUE_LEVEL_SCHEMA);
                Schema realSemanticSchema = (Schema)semanticSchema.getTypes().get(typeIdx);
                return this.analyzeItem(AvroUtils.itemId((String)itemId, (String)realItemSchema.getName()), item, realItemSchema, realResultSchema, realSemanticSchema);
            }
            case ENUM: 
            case FIXED: 
            case STRING: 
            case BYTES: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                GenericData.Record semRecord = new GenericData.Record(QUALITY_VALUE_LEVEL_SCHEMA);
                semRecord.put("validity", (Object)this.analyzeLeafValue(itemId, item, this.fieldCategories.get(itemId)));
                return semRecord;
            }
            case NULL: {
                GenericData.Record nullSemRecord = new GenericData.Record(QUALITY_VALUE_LEVEL_SCHEMA);
                nullSemRecord.put("validity", (Object)this.analyzeLeafValue(itemId, item, null));
                return nullSemRecord;
            }
        }
        throw new IllegalStateException("Unexpected value: " + itemSchema.getType());
    }

    private int analyzeLeafValue(String id, Object objValue, String semanticType) {
        String value = objValue == null ? "" : objValue.toString();
        ValueQualityStatistics valueQuality = this.qualityResults.computeIfAbsent(id, $ -> new ValueQualityStatistics());
        return this.commonQualityAnalyzer.analyzeValue(semanticType, value, valueQuality);
    }

    public void close() {
    }
}

