/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.statistics;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.talend.dataquality.common.inference.ValueQualityStatistics;
import org.talend.dataquality.common.util.LFUCache;
import org.talend.dataquality.semantic.classifier.ISubCategoryClassifier;
import org.talend.dataquality.semantic.model.CategoryType;
import org.talend.dataquality.semantic.model.DQCategory;
import org.talend.dataquality.semantic.recognizer.DefaultCategoryRecognizer;
import org.talend.dataquality.semantic.snapshot.DictionarySnapshot;

public class CommonQualityAnalyzer {
    private final Map<String, LFUCache<String, Boolean>> knownValidationCategoryCache = new HashMap<String, LFUCache<String, Boolean>>();
    private final DictionarySnapshot dictionarySnapshot;
    private ISubCategoryClassifier regexClassifier;
    private ISubCategoryClassifier dataDictClassifier;
    private final boolean isStoreInvalidValues;

    public CommonQualityAnalyzer(DictionarySnapshot dictionarySnapshot, boolean isStoreInvalidValues) {
        this.dictionarySnapshot = dictionarySnapshot;
        this.isStoreInvalidValues = isStoreInvalidValues;
    }

    public DictionarySnapshot getDictionarySnapshot() {
        return this.dictionarySnapshot;
    }

    public void init() {
        DefaultCategoryRecognizer recognizer = new DefaultCategoryRecognizer(this.dictionarySnapshot);
        this.regexClassifier = recognizer.getUserDefineClassifier();
        this.dataDictClassifier = recognizer.getDataDictFieldClassifier();
    }

    private boolean isCompoundValid(DQCategory category, String value) {
        boolean validCat = false;
        HashSet<DQCategory> regexChildrenCategories = new HashSet<DQCategory>();
        HashSet<DQCategory> dictChildrenCategories = new HashSet<DQCategory>();
        for (DQCategory cat : category.getChildren()) {
            if (CategoryType.DICT.equals((Object)cat.getType())) {
                dictChildrenCategories.add(cat);
                continue;
            }
            if (!CategoryType.REGEX.equals((Object)cat.getType())) continue;
            regexChildrenCategories.add(cat);
        }
        if (!CollectionUtils.isEmpty(regexChildrenCategories)) {
            validCat = this.regexClassifier.validCategories(value, category, regexChildrenCategories);
        }
        if (!validCat && !CollectionUtils.isEmpty(dictChildrenCategories)) {
            validCat = this.dataDictClassifier.validCategories(value, category, dictChildrenCategories);
        }
        return validCat;
    }

    private void processInvalidValue(ValueQualityStatistics valueQuality, String invalidValue) {
        if (this.isStoreInvalidValues) {
            valueQuality.appendInvalidValue(invalidValue);
        }
    }

    public int analyzeValue(String DqCategoryId, String value, ValueQualityStatistics valueQuality) {
        int validity = this.analyzeValue(DqCategoryId, value);
        switch (validity) {
            case 0: {
                valueQuality.incrementEmpty();
                break;
            }
            case 1: {
                valueQuality.incrementValid();
                break;
            }
            case -1: {
                valueQuality.incrementInvalid();
                this.processInvalidValue(valueQuality, value);
            }
        }
        return validity;
    }

    public int analyzeValue(String DqCategoryId, String value) {
        if (value == null || value.trim().length() == 0) {
            return 0;
        }
        DQCategory category = this.dictionarySnapshot.getMetadata().get(DqCategoryId);
        if (category == null) {
            return 1;
        }
        if (Boolean.TRUE.equals(category.getCompleteness())) {
            return !Boolean.TRUE.equals(category.getDeleted()) && this.isValid(category, value) ? 1 : -1;
        }
        return 1;
    }

    public boolean isValid(DQCategory category, String value) {
        LFUCache categoryCache = this.knownValidationCategoryCache.get(category.getId());
        if (categoryCache == null) {
            categoryCache = new LFUCache(10, 1000, 0.01f);
            this.knownValidationCategoryCache.put(category.getId(), (LFUCache<String, Boolean>)categoryCache);
        } else {
            Boolean isValid = (Boolean)categoryCache.get((Object)value);
            if (isValid != null) {
                return isValid;
            }
        }
        boolean validCat = false;
        switch (category.getType()) {
            case REGEX: {
                validCat = this.regexClassifier.validCategories(value, category, null);
                break;
            }
            case DICT: {
                validCat = this.dataDictClassifier.validCategories(value, category, null);
                break;
            }
            case COMPOUND: {
                validCat = this.isCompoundValid(category, value);
                break;
            }
        }
        categoryCache.put((Object)value, (Object)validCat);
        return validCat;
    }

    public List<DQCategory> getChildrenCategories(String id) {
        ArrayDeque<String> catToSee = new ArrayDeque<String>();
        HashSet catAlreadySeen = new HashSet();
        ArrayList<DQCategory> children = new ArrayList<DQCategory>();
        catToSee.add(id);
        while (!catToSee.isEmpty()) {
            String currentCategory = (String)catToSee.pop();
            DQCategory dqCategory = this.dictionarySnapshot.getMetadata().get(currentCategory);
            if (dqCategory == null) continue;
            if (!CollectionUtils.isEmpty((Collection)dqCategory.getChildren())) {
                dqCategory.getChildren().stream().filter(child -> !catAlreadySeen.contains(child.getId())).forEach(child -> {
                    catAlreadySeen.add(child.getId());
                    catToSee.add(child.getId());
                });
                continue;
            }
            if (currentCategory.equals(id)) continue;
            children.add(dqCategory);
        }
        return children;
    }
}

