/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.statistics;

import java.util.ArrayList;
import java.util.List;
import org.talend.dataquality.common.inference.QualityAnalyzer;
import org.talend.dataquality.common.inference.ResizableList;
import org.talend.dataquality.common.inference.ValueQualityStatistics;
import org.talend.dataquality.semantic.classifier.SemanticCategoryEnum;
import org.talend.dataquality.semantic.model.DQCategory;
import org.talend.dataquality.semantic.snapshot.DictionarySnapshot;
import org.talend.dataquality.semantic.statistics.CommonQualityAnalyzer;

public class SemanticQualityAnalyzer
extends QualityAnalyzer<ValueQualityStatistics, String[]> {
    private static final long serialVersionUID = -5951511723860660263L;
    private final ResizableList<ValueQualityStatistics> results = new ResizableList(ValueQualityStatistics::new);
    private final CommonQualityAnalyzer commonQualityAnalyzer;

    public SemanticQualityAnalyzer(DictionarySnapshot dictionarySnapshot, String[] types, boolean isStoreInvalidValues) {
        this.commonQualityAnalyzer = new CommonQualityAnalyzer(dictionarySnapshot, isStoreInvalidValues);
        this.init();
        this.setTypes(types);
    }

    public SemanticQualityAnalyzer(DictionarySnapshot dictionarySnapshot, String ... types) {
        this(dictionarySnapshot, types, false);
    }

    public boolean isValid(DQCategory category, String value) {
        return this.commonQualityAnalyzer.isValid(category, value);
    }

    public void setTypes(String[] types) {
        ArrayList<String> idList = new ArrayList<String>();
        for (String type : types) {
            DQCategory dqCat = null;
            for (DQCategory tmpCat : this.commonQualityAnalyzer.getDictionarySnapshot().getMetadata().values()) {
                if (!type.equals(tmpCat.getName())) continue;
                tmpCat.setChildren(this.commonQualityAnalyzer.getChildrenCategories(tmpCat.getId()));
                dqCat = tmpCat;
                break;
            }
            if (dqCat == null) {
                idList.add(SemanticCategoryEnum.UNKNOWN.name());
                continue;
            }
            idList.add(dqCat.getId());
        }
        super.setTypes((Object)idList.toArray(new String[0]));
    }

    public void init() {
        this.commonQualityAnalyzer.init();
        this.results.clear();
    }

    @Deprecated
    public void setStoreInvalidValues(boolean isStoreInvalidValues) {
        this.isStoreInvalidValues = isStoreInvalidValues;
    }

    public boolean analyze(String ... record) {
        if (record == null) {
            this.results.resize(0);
            return false;
        }
        this.results.resize(record.length);
        for (int i = 0; i < record.length; ++i) {
            this.commonQualityAnalyzer.analyzeValue(((String[])this.getTypes())[i], record[i], (ValueQualityStatistics)this.results.get(i));
        }
        return true;
    }

    public void end() {
    }

    public List<ValueQualityStatistics> getResult() {
        return this.results;
    }

    public void close() {
    }
}

