/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.statistics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.talend.dataquality.semantic.recognizer.CategoryFrequency;

public class SemanticType {
    private Map<CategoryFrequency, Long> categoryToCount = new HashMap<CategoryFrequency, Long>();

    public Map<CategoryFrequency, Long> getCategoryToCount() {
        return this.categoryToCount;
    }

    public String getSuggestedCategory() {
        return this.getSuggestedCategories().get(0).getCategoryId();
    }

    public List<CategoryFrequency> getSuggestedCategories() {
        ArrayList<CategoryFrequency> frequencies = new ArrayList<CategoryFrequency>(this.categoryToCount.keySet());
        Collections.sort(frequencies, Collections.reverseOrder());
        return frequencies;
    }

    public void increment(CategoryFrequency category, long count) {
        if (!this.categoryToCount.containsKey(category)) {
            this.categoryToCount.put(category, count);
        } else {
            this.categoryToCount.put(category, this.categoryToCount.get(category) + count);
        }
    }

    public String toString() {
        return "SemanticType{categoryToCount=" + this.categoryToCount + '}';
    }
}

