/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.validator;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.regex.Pattern;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedRE2JRegexValidator;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedRegexValidator;
import org.talend.dataquality.semantic.validator.ISemanticValidator;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="re2jCompliant", defaultImpl=UserDefinedRegexValidator.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=UserDefinedRE2JRegexValidator.class, name="true"), @JsonSubTypes.Type(value=UserDefinedRegexValidator.class, name="false")})
@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class AbstractRegexSemanticValidator
implements ISemanticValidator {
    private static final long serialVersionUID = -8373360239860394354L;
    protected Pattern caseSensitivePattern;
    protected Pattern caseInsensitivePattern;
    private Boolean generexCompliant = false;

    @Override
    public boolean isValid(String str, boolean caseSensitive) {
        if (str == null || this.caseSensitivePattern == null || this.caseInsensitivePattern == null) {
            return false;
        }
        return caseSensitive ? this.caseSensitivePattern.matcher(str.trim()).find() : this.caseInsensitivePattern.matcher(str.trim()).find();
    }

    @Override
    public boolean isValid(String str) {
        return this.isValid(str, false);
    }

    public Boolean getGenerexCompliant() {
        return this.generexCompliant;
    }

    public void setGenerexCompliant(Boolean generexCompliant) {
        this.generexCompliant = generexCompliant;
    }
}

