/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.lucene.document.Document;
import org.talend.dataquality.semantic.datamasking.GenerateFromRegex;
import org.talend.dataquality.semantic.datamasking.model.CategoryValues;
import org.talend.dataquality.semantic.index.Index;
import org.talend.dataquality.semantic.index.LuceneIndex;
import org.talend.dataquality.semantic.model.CategoryType;
import org.talend.dataquality.semantic.model.DQCategory;
import org.talend.dataquality.semantic.snapshot.DictionarySnapshot;

public class GenerateValidator {
    private GenerateValidator() {
    }

    public static List<CategoryValues> initSemanticTypes(DictionarySnapshot dictionarySnapshot, DQCategory cat) {
        ArrayList<CategoryValues> categoryValues = new ArrayList<CategoryValues>();
        cat.getChildren().stream().filter(child -> dictionarySnapshot.getMetadata().containsKey(child.getId())).forEach(child -> {
            String childID = child.getId();
            DQCategory completeChild = dictionarySnapshot.getMetadata().get(childID);
            CategoryType childType = completeChild.getType();
            switch (childType) {
                case DICT: {
                    GenerateValidator.addCategoryValues(categoryValues, dictionarySnapshot, completeChild, childID);
                    break;
                }
                case REGEX: {
                    GenerateValidator.addRegexPatternIfValid(categoryValues, dictionarySnapshot, completeChild, childID);
                    break;
                }
                case COMPOUND: {
                    categoryValues.addAll(GenerateValidator.initSemanticTypes(dictionarySnapshot, completeChild));
                    break;
                }
            }
        });
        return categoryValues;
    }

    private static void addCategoryValues(List<CategoryValues> categoryValues, DictionarySnapshot dictionarySnapshot, DQCategory completeChild, String childID) {
        ArrayList<String> values = new ArrayList<String>();
        if (!completeChild.getModified().booleanValue()) {
            values.addAll(GenerateValidator.getValuesFromIndex(dictionarySnapshot.getSharedDataDict(), completeChild.getId()));
        } else {
            values.addAll(GenerateValidator.getValuesFromIndex(dictionarySnapshot.getCustomDataDict(), completeChild.getId()));
        }
        CategoryValues catValue = new CategoryValues();
        catValue.setCategoryId(childID);
        catValue.setName(completeChild.getName());
        catValue.setType(CategoryType.DICT);
        catValue.setValue(values);
        categoryValues.add(catValue);
    }

    private static void addRegexPatternIfValid(List<CategoryValues> categoryValues, DictionarySnapshot dictionarySnapshot, DQCategory completeChild, String childID) {
        String pattern = dictionarySnapshot.getRegexClassifier().getPatternStringByCategoryId(childID);
        if (GenerateFromRegex.isValidPattern(pattern)) {
            CategoryValues catValue = new CategoryValues();
            catValue.setCategoryId(childID);
            catValue.setName(completeChild.getName());
            catValue.setType(CategoryType.REGEX);
            catValue.setValue(pattern);
            categoryValues.add(catValue);
        }
    }

    private static List<String> getValuesFromIndex(Index index, String categoryId) {
        List<Document> listLuceneDocs = ((LuceneIndex)index).getSearcher().listDocumentsByCategoryId(categoryId);
        return listLuceneDocs.stream().flatMap(doc -> Arrays.stream(doc.getValues("raw"))).collect(Collectors.toList());
    }
}

