/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.validator.impl;

import org.apache.commons.lang3.StringUtils;
import org.talend.dataquality.semantic.exception.DQSemanticRuntimeException;
import org.talend.dataquality.semantic.validator.ISemanticSubValidator;

public class SedolValidator
implements ISemanticSubValidator {
    private static final int[] mult = new int[]{1, 3, 1, 7, 3, 9};

    @Override
    public boolean isValid(String str) {
        if (str == null || str.length() != 7) {
            return false;
        }
        String sedolStr = StringUtils.left((String)str, (int)6);
        int checksum = -1;
        try {
            String csStr = StringUtils.right((String)str, (int)1);
            checksum = Integer.valueOf(csStr);
        }
        catch (NumberFormatException e) {
            throw new DQSemanticRuntimeException("Invalid checksum digit. ", e);
        }
        int checksumFromSedol = this.getSedolCheckDigit(sedolStr);
        return checksum == checksumFromSedol;
    }

    public int getSedolCheckDigit(String str) {
        String strUpper = str.toUpperCase();
        int total = 0;
        for (int i = 0; i < 6; ++i) {
            char s = strUpper.charAt(i);
            total += Character.digit(s, 36) * mult[i];
        }
        return (10 - total % 10) % 10;
    }
}

