/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dtc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.postgresql.util.PSQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dtc.JobStatus;

public class DTCJobWriter {
    private static final Logger log = LoggerFactory.getLogger(DTCJobWriter.class);
    private static final String JDBC_URL = String.format("jdbc:postgresql://%s:%s/DTC", System.getenv("POSTGRES_HOST"), System.getenv("POSTGRES_PORT"));
    private static final String JDBC_USER = System.getenv("POSTGRES_USER");
    private static final String JDBC_PASSWORD = System.getenv("POSTGRES_PASSWORD");
    private String jobName;
    private String branch;
    private String tag;
    private String language;
    private JobStatus jobStatus;
    private String jobLogs;
    private long duration;
    private List<String> components;

    public DTCJobWriter(String jobName, String branch, String tag, String language, JobStatus jobStatus, String jobLogs, long duration, List<String> components) {
        this.jobName = jobName;
        this.branch = this.adaptBranch(branch);
        this.tag = tag;
        this.language = language;
        this.jobStatus = jobStatus;
        this.jobLogs = jobLogs;
        this.duration = duration;
        this.components = components;
    }

    private String adaptBranch(String branch) {
        if ("8.0.1".equals(branch)) {
            branch = "8.0.2";
        }
        if (System.getenv("DTC_BRANCH") != null) {
            return System.getenv("DTC_BRANCH");
        }
        return branch;
    }

    public void sendJobStatus() {
        log.info("Attempting to send complete job status for job: {} on branch: {} and tag: {}", new Object[]{this.jobName, this.branch, this.tag});
        try (Connection connection = this.getConnection();){
            if (connection != null) {
                int jobId = this.writeJob(connection, this.jobName, this.components, this.branch);
                if (jobId == -1) {
                    log.error("Failed to register/get job ID for job: {}. Cannot proceed with status updates.", (Object)this.jobName);
                    return;
                }
                this.writeJobData(connection, jobId, this.branch, this.tag, this.language, this.jobStatus, this.jobLogs, this.duration);
                this.createExecutionIfNotExists(connection, this.branch, this.tag);
                this.updateExecutionData(connection, this.branch, this.tag, this.jobStatus);
            }
        }
        catch (SQLException e) {
            log.error("Failed to connect or perform job status sending.", (Throwable)e);
        }
    }

    private Connection getConnection() {
        try {
            return DriverManager.getConnection(JDBC_URL, JDBC_USER, JDBC_PASSWORD);
        }
        catch (SQLException e) {
            log.error("Failed to establish database connection.", (Throwable)e);
            return null;
        }
    }

    private void createExecutionIfNotExists(Connection connection, String branch, String tag) throws SQLException {
        int totalJobCount = this.countJobsForBranch(connection, branch);
        log.info("Found {} total jobs for branch: {} to initialize execution counter.", (Object)totalJobCount, (Object)branch);
        String sql = "INSERT INTO executions (branch, tag, nbjobs, jobs_ok, jobs_ko, jobs_fail) VALUES (?, ?, ?, 0, 0, 0) ON CONFLICT (branch, tag) DO NOTHING";
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            preparedStatement.setString(1, branch);
            preparedStatement.setString(2, tag);
            preparedStatement.setInt(3, totalJobCount);
            int rowsAffected = preparedStatement.executeUpdate();
            if (rowsAffected > 0) {
                log.info("New execution entry created for branch: {} and tag: {} with total jobs: {}", new Object[]{branch, tag, totalJobCount});
            } else {
                log.debug("Execution entry already exists for branch: {} and tag: {}. Skipping creation.", (Object)branch, (Object)tag);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int countJobsForBranch(Connection connection, String branch) throws SQLException {
        if (branch.contains("-")) {
            branch = branch.split("-")[0];
        }
        String sql = "SELECT COUNT(*) FROM jobs WHERE branches @> ARRAY[?]::text[]";
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            preparedStatement.setString(1, branch);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (!resultSet.next()) return 0;
                int n = resultSet.getInt(1);
                return n;
            }
        }
        catch (PSQLException e) {
            log.warn("Database error during job counting (check operator @>): {}", (Object)e.getMessage());
        }
        return 0;
    }

    private void updateExecutionData(Connection connection, String branch, String tag, JobStatus status) throws SQLException {
        String statusColumn;
        switch (status) {
            case OK: {
                statusColumn = "jobs_ok";
                break;
            }
            case LOGICAL_FAILURE: {
                statusColumn = "jobs_ko";
                break;
            }
            case ERROR: {
                statusColumn = "jobs_fail";
                break;
            }
            default: {
                log.warn("Unknown JobStatus: {}. Skipping execution status update.", (Object)status);
                return;
            }
        }
        String sql = String.format("UPDATE executions SET %s = %s + 1 WHERE branch = ? AND tag = ?", statusColumn, statusColumn);
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            preparedStatement.setString(1, branch);
            preparedStatement.setString(2, tag);
            int updatedRows = preparedStatement.executeUpdate();
            if (updatedRows == 1) {
                log.info("Execution status successfully updated for branch: {} and tag: {}. Status: {}", new Object[]{branch, tag, status});
            } else {
                log.error("Failed to update execution entry for branch: {} and tag: {}. Row not found after attempted creation.", (Object)branch, (Object)tag);
            }
        }
    }

    private int writeJob(Connection connection, String jobName, List<String> components, String branch) throws SQLException {
        int generatedId = -1;
        String sql = "INSERT INTO jobs (name, family, components, branches, mode) VALUES (?, ?, ?, ?, 0) ON CONFLICT (name) DO UPDATE SET   components = EXCLUDED.components,   branches = CASE     WHEN ARRAY_POSITION(jobs.branches, EXCLUDED.branches[1]) IS NULL     THEN array_append(jobs.branches, EXCLUDED.branches[1])     ELSE jobs.branches   END RETURNING id";
        try (PreparedStatement pstmt = connection.prepareStatement(sql);){
            pstmt.setString(1, jobName);
            pstmt.setString(2, "orphan");
            pstmt.setArray(3, connection.createArrayOf("text", components.toArray(new String[0])));
            pstmt.setArray(4, connection.createArrayOf("text", List.of(branch).toArray(new String[0])));
            ResultSet resultSet = pstmt.executeQuery();
            if (resultSet.next()) {
                generatedId = resultSet.getInt("id");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return generatedId;
    }

    private void writeJobData(Connection connection, Integer jobId, String branch, String tag, String language, JobStatus status, String jobLogs, long duration) {
        String sql = "INSERT INTO jobsexecution (jobid, branch, tag, language, status, logs, duration) VALUES (?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            preparedStatement.setInt(1, jobId);
            preparedStatement.setString(2, branch);
            preparedStatement.setString(3, tag);
            preparedStatement.setString(4, language);
            preparedStatement.setString(5, status.toString());
            preparedStatement.setString(6, jobLogs);
            preparedStatement.setLong(7, duration);
            preparedStatement.executeUpdate();
            log.info("job's data written");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

